/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.kinesis.integration;

import io.awspring.cloud.kinesis.integration.ConvertingFromMessageConverter;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.MessageTimeoutException;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.mapping.OutboundMessageMapper;
import org.springframework.integration.support.MutableMessage;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.services.kinesis.model.KinesisResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;

public class KinesisMessageHandler
extends AbstractMessageProducingHandler {
    private static final long DEFAULT_SEND_TIMEOUT = 10000L;
    private final KinesisAsyncClient amazonKinesis;
    private MessageConverter messageConverter = new ConvertingFromMessageConverter((Converter<Object, ?>)new SerializingConverter());
    private Expression streamExpression;
    private Expression partitionKeyExpression;
    private Expression explicitHashKeyExpression;
    private Expression sequenceNumberExpression;
    private OutboundMessageMapper<byte[]> embeddedHeadersMapper;
    private EvaluationContext evaluationContext;
    private Expression sendTimeoutExpression = new ValueExpression((Object)10000L);

    public KinesisMessageHandler(KinesisAsyncClient amazonKinesis) {
        Assert.notNull((Object)amazonKinesis, (String)"'amazonKinesis' must not be null.");
        this.amazonKinesis = amazonKinesis;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        Assert.notNull((Object)messageConverter, (String)"'messageConverter' must not be null.");
        this.messageConverter = messageConverter;
    }

    public void setStream(String stream) {
        this.setStreamExpression((Expression)new LiteralExpression(stream));
    }

    public void setStreamExpressionString(String streamExpression) {
        this.setStreamExpression(EXPRESSION_PARSER.parseExpression(streamExpression));
    }

    public void setStreamExpression(Expression streamExpression) {
        this.streamExpression = streamExpression;
    }

    public void setPartitionKey(String partitionKey) {
        this.setPartitionKeyExpression((Expression)new LiteralExpression(partitionKey));
    }

    public void setPartitionKeyExpressionString(String partitionKeyExpression) {
        this.setPartitionKeyExpression(EXPRESSION_PARSER.parseExpression(partitionKeyExpression));
    }

    public void setPartitionKeyExpression(Expression partitionKeyExpression) {
        this.partitionKeyExpression = partitionKeyExpression;
    }

    public void setExplicitHashKey(String explicitHashKey) {
        this.setExplicitHashKeyExpression((Expression)new LiteralExpression(explicitHashKey));
    }

    public void setExplicitHashKeyExpressionString(String explicitHashKeyExpression) {
        this.setExplicitHashKeyExpression(EXPRESSION_PARSER.parseExpression(explicitHashKeyExpression));
    }

    public void setExplicitHashKeyExpression(Expression explicitHashKeyExpression) {
        this.explicitHashKeyExpression = explicitHashKeyExpression;
    }

    public void setSequenceNumberExpressionString(String sequenceNumberExpression) {
        this.setSequenceNumberExpression(EXPRESSION_PARSER.parseExpression(sequenceNumberExpression));
    }

    public void setSequenceNumberExpression(Expression sequenceNumberExpression) {
        this.sequenceNumberExpression = sequenceNumberExpression;
    }

    public void setEmbeddedHeadersMapper(OutboundMessageMapper<byte[]> embeddedHeadersMapper) {
        this.embeddedHeadersMapper = embeddedHeadersMapper;
    }

    public void setSendTimeout(long sendTimeout) {
        this.setSendTimeoutExpression((Expression)new ValueExpression((Object)sendTimeout));
    }

    public void setSendTimeoutExpressionString(String sendTimeoutExpression) {
        this.setSendTimeoutExpression(EXPRESSION_PARSER.parseExpression(sendTimeoutExpression));
    }

    public void setSendTimeoutExpression(Expression sendTimeoutExpression) {
        Assert.notNull((Object)sendTimeoutExpression, (String)"'sendTimeoutExpression' must not be null");
        this.sendTimeoutExpression = sendTimeoutExpression;
    }

    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)this.getBeanFactory());
    }

    protected boolean shouldCopyRequestHeaders() {
        return false;
    }

    protected void handleMessageInternal(Message<?> message) {
        KinesisRequest request = this.messageToAwsRequest(message);
        CompletionStage resultFuture = this.handleMessageToAws(request).handle((response, ex) -> this.handleResponse(message, request, (KinesisResponse)response, (Throwable)ex));
        if (this.isAsync()) {
            this.sendOutputs(resultFuture, message);
            return;
        }
        Long sendTimeout = (Long)this.sendTimeoutExpression.getValue(this.evaluationContext, message, Long.class);
        try {
            if (sendTimeout == null || sendTimeout < 0L) {
                ((CompletableFuture)resultFuture).get();
            } else {
                ((CompletableFuture)resultFuture).get(sendTimeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException te) {
            throw new MessageTimeoutException(message, "Timeout waiting for response from AmazonKinesis", (Throwable)te);
        }
        catch (InterruptedException ex2) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex2);
        }
        catch (ExecutionException ex3) {
            throw new IllegalStateException(ex3);
        }
    }

    protected Message<?> handleResponse(Message<?> message, KinesisRequest request, KinesisResponse response, Throwable cause) {
        if (cause != null) {
            throw new MessageHandlingException(message, cause);
        }
        return this.getMessageBuilderFactory().fromMessage(message).copyHeadersIfAbsent(this.additionalOnSuccessHeaders(request, response)).build();
    }

    private KinesisRequest messageToAwsRequest(Message<?> message) {
        PutRecordRequest putRecordRequest;
        Object object = message.getPayload();
        if (object instanceof PutRecordsRequest) {
            PutRecordsRequest putRecordsRequest = (PutRecordsRequest)object;
            return putRecordsRequest;
        }
        Object object2 = message.getPayload();
        return object2 instanceof PutRecordRequest ? (putRecordRequest = (PutRecordRequest)object2) : this.buildPutRecordRequest(message);
    }

    private PutRecordRequest buildPutRecordRequest(Message<?> message) {
        MessageHeaders messageHeaders = message.getHeaders();
        String stream = (String)messageHeaders.get((Object)"Kinesis_stream", String.class);
        if (!StringUtils.hasText((String)stream) && this.streamExpression != null) {
            stream = (String)this.streamExpression.getValue(this.evaluationContext, message, String.class);
        }
        Assert.state((stream != null ? 1 : 0) != 0, (String)"'stream' must not be null for sending a Kinesis record. Consider configuring this handler with a 'stream'( or 'streamExpression') or supply an 'aws_stream' message header.");
        String partitionKey = (String)messageHeaders.get((Object)"Kinesis_partitionKey", String.class);
        if (!StringUtils.hasText((String)partitionKey) && this.partitionKeyExpression != null) {
            partitionKey = (String)this.partitionKeyExpression.getValue(this.evaluationContext, message, String.class);
        }
        Assert.state((partitionKey != null ? 1 : 0) != 0, (String)"'partitionKey' must not be null for sending a Kinesis record. Consider configuring this handler with a 'partitionKey'( or 'partitionKeyExpression') or supply an 'aws_partitionKey' message header.");
        String explicitHashKey = this.explicitHashKeyExpression != null ? (String)this.explicitHashKeyExpression.getValue(this.evaluationContext, message, String.class) : null;
        String sequenceNumber = (String)messageHeaders.get((Object)"Kinesis_sequenceNumber", String.class);
        if (!StringUtils.hasText((String)sequenceNumber) && this.sequenceNumberExpression != null) {
            sequenceNumber = (String)this.sequenceNumberExpression.getValue(this.evaluationContext, message, String.class);
        }
        Object payload = message.getPayload();
        SdkBytes data = null;
        MutableMessage messageToEmbed = null;
        if (payload instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)payload;
            data = SdkBytes.fromByteBuffer((ByteBuffer)byteBuffer);
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)data.asByteArray(), (Map)messageHeaders);
            }
        } else {
            byte[] bytes = (byte[])(payload instanceof byte[] ? payload : this.messageConverter.fromMessage(message, byte[].class));
            Assert.notNull((Object)bytes, (String)"payload cannot be null");
            if (this.embeddedHeadersMapper != null) {
                messageToEmbed = new MutableMessage((Object)bytes, (Map)messageHeaders);
            } else {
                data = SdkBytes.fromByteArray((byte[])bytes);
            }
        }
        if (messageToEmbed != null) {
            try {
                byte[] bytes = (byte[])this.embeddedHeadersMapper.fromMessage((Message)messageToEmbed);
                Assert.notNull((Object)bytes, (String)"payload cannot be null");
                data = SdkBytes.fromByteArray((byte[])bytes);
            }
            catch (Exception ex) {
                throw new MessageConversionException(message, "Cannot embedded headers to payload", (Throwable)ex);
            }
        }
        return (PutRecordRequest)PutRecordRequest.builder().streamName(stream).partitionKey(partitionKey).explicitHashKey(explicitHashKey).sequenceNumberForOrdering(sequenceNumber).data(data).build();
    }

    private CompletableFuture<? extends KinesisResponse> handleMessageToAws(KinesisRequest request) {
        if (request instanceof PutRecordsRequest) {
            PutRecordsRequest putRecordsRequest = (PutRecordsRequest)request;
            return this.amazonKinesis.putRecords(putRecordsRequest);
        }
        return this.amazonKinesis.putRecord((PutRecordRequest)request);
    }

    protected Map<String, ?> additionalOnSuccessHeaders(KinesisRequest request, KinesisResponse response) {
        if (response instanceof PutRecordResponse) {
            PutRecordResponse putRecordResponse = (PutRecordResponse)response;
            return Map.of("Kinesis_shard", putRecordResponse.shardId(), "Kinesis_sequenceNumber", putRecordResponse.sequenceNumber(), "Kinesis_serviceResult", response);
        }
        return Map.of("Kinesis_serviceResult", response);
    }
}

