/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.datasource;

import io.awspring.cloud.jdbc.datasource.support.DatabaseType;
import org.springframework.util.Assert;

public final class DataSourceInformation {
    private final DatabaseType databaseType;
    private final String hostName;
    private final Integer port;
    private final String databaseName;
    private final String userName;
    private final String password;

    public DataSourceInformation(DatabaseType databaseType, String hostName, Integer port, String databaseName, String userName, String password) {
        Assert.notNull((Object)((Object)databaseType), (String)"DatabaseType must not be null");
        Assert.notNull((Object)hostName, (String)"Hostname must not be null");
        Assert.notNull((Object)port, (String)"Port must not be null");
        Assert.notNull((Object)userName, (String)"UserName must not be null");
        Assert.notNull((Object)password, (String)"Password must not be null");
        this.databaseType = databaseType;
        this.hostName = hostName;
        this.port = port;
        this.databaseName = databaseName;
        this.userName = userName;
        this.password = password;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        int result = this.databaseType.hashCode();
        result = 31 * result + this.hostName.hashCode();
        result = 31 * result + this.port.hashCode();
        result = 31 * result + this.databaseName.hashCode();
        result = 31 * result + this.userName.hashCode();
        result = 31 * result + this.password.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataSourceInformation)) {
            return false;
        }
        DataSourceInformation that = (DataSourceInformation)obj;
        if (this.databaseType != that.getDatabaseType()) {
            return false;
        }
        if (!this.databaseName.equals(that.getDatabaseName())) {
            return false;
        }
        if (!this.hostName.equals(that.getHostName())) {
            return false;
        }
        if (!this.password.equals(that.getPassword())) {
            return false;
        }
        if (!this.port.equals(that.getPort())) {
            return false;
        }
        return this.userName.equals(that.getUserName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DataSourceInformation");
        sb.append("{databaseType=").append((Object)this.databaseType);
        sb.append(", hostName='").append(this.hostName).append("'");
        sb.append(", port=").append(this.port);
        sb.append(", databaseName='").append(this.databaseName).append("'");
        sb.append(", userName='").append(this.userName).append("'");
        sb.append(", password='").append(this.password).append("'");
        sb.append("}");
        return sb.toString();
    }
}

