/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.dynamodb;

import io.awspring.cloud.dynamodb.DynamoDbTableNameResolver;
import java.util.Locale;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultDynamoDbTableNameResolver
implements DynamoDbTableNameResolver {
    @Nullable
    private final String tablePrefix;

    public DefaultDynamoDbTableNameResolver(@Nullable String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public DefaultDynamoDbTableNameResolver() {
        this(null);
    }

    public String resolve(Class clazz) {
        Assert.notNull((Object)clazz, (String)"clazz is required");
        String prefix = StringUtils.hasText((String)this.tablePrefix) ? this.tablePrefix : "";
        return prefix.concat(clazz.getSimpleName().replaceAll("(.)(\\p{Lu})", "$1_$2").toLowerCase(Locale.ROOT));
    }
}

