/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.dynamodb;

import io.awspring.cloud.dynamodb.DefaultDynamoDbTableNameResolver;
import io.awspring.cloud.dynamodb.DefaultDynamoDbTableSchemaResolver;
import io.awspring.cloud.dynamodb.DynamoDbOperations;
import io.awspring.cloud.dynamodb.DynamoDbTableNameResolver;
import io.awspring.cloud.dynamodb.DynamoDbTableSchemaResolver;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryEnhancedRequest;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;

public class DynamoDbTemplate
implements DynamoDbOperations {
    private final DynamoDbEnhancedClient dynamoDbEnhancedClient;
    private final DynamoDbTableSchemaResolver dynamoDbTableSchemaResolver;
    private final DynamoDbTableNameResolver dynamoDbTableNameResolver;

    public DynamoDbTemplate(DynamoDbEnhancedClient dynamoDbEnhancedClient) {
        this(dynamoDbEnhancedClient, new DefaultDynamoDbTableSchemaResolver(), new DefaultDynamoDbTableNameResolver());
    }

    public DynamoDbTemplate(DynamoDbEnhancedClient dynamoDbEnhancedClient, DynamoDbTableSchemaResolver dynamoDbTableSchemaResolver, DynamoDbTableNameResolver dynamoDbTableNameResolver) {
        this.dynamoDbEnhancedClient = dynamoDbEnhancedClient;
        this.dynamoDbTableSchemaResolver = dynamoDbTableSchemaResolver;
        this.dynamoDbTableNameResolver = dynamoDbTableNameResolver;
    }

    @Override
    public <T> T save(T entity) {
        this.prepareTable(entity).putItem(entity);
        return entity;
    }

    @Override
    public <T> T update(T entity) {
        return (T)this.prepareTable(entity).updateItem(entity);
    }

    @Override
    public void delete(Key key, Class<?> clazz) {
        this.prepareTable(clazz).deleteItem(key);
    }

    @Override
    public <T> void delete(T entity) {
        this.prepareTable(entity).deleteItem(entity);
    }

    @Override
    @Nullable
    public <T> T load(Key key, Class<T> clazz) {
        return (T)this.prepareTable(clazz).getItem(key);
    }

    @Override
    public <T> PageIterable<T> scan(ScanEnhancedRequest scanEnhancedRequest, Class<T> clazz) {
        return this.prepareTable(clazz).scan(scanEnhancedRequest);
    }

    @Override
    public <T> PageIterable<T> scanAll(Class<T> clazz) {
        return this.prepareTable(clazz).scan();
    }

    @Override
    public <T> PageIterable<T> query(QueryEnhancedRequest queryEnhancedRequest, Class<T> clazz) {
        return this.prepareTable(clazz).query(queryEnhancedRequest);
    }

    private <T> DynamoDbTable<T> prepareTable(T entity) {
        String tableName = this.dynamoDbTableNameResolver.resolve(entity.getClass());
        return this.dynamoDbEnhancedClient.table(tableName, this.dynamoDbTableSchemaResolver.resolve(entity.getClass(), tableName));
    }

    private <T> DynamoDbTable<T> prepareTable(Class<T> clazz) {
        String tableName = this.dynamoDbTableNameResolver.resolve(clazz);
        return this.dynamoDbEnhancedClient.table(tableName, this.dynamoDbTableSchemaResolver.resolve(clazz, tableName));
    }
}

