/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.cache.config.annotation;

import com.amazonaws.services.elasticache.AmazonElastiCache;
import io.awspring.cloud.cache.CacheFactory;
import io.awspring.cloud.cache.ElastiCacheFactoryBean;
import io.awspring.cloud.core.env.ResourceIdResolver;
import java.util.ArrayList;
import java.util.List;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.support.SimpleCacheManager;

public class ElastiCacheCacheConfigurer
extends CachingConfigurerSupport {
    private final AmazonElastiCache amazonElastiCache;
    private final ResourceIdResolver resourceIdResolver;
    private final List<String> cacheNames;
    private final List<CacheFactory> cacheFactories;

    public ElastiCacheCacheConfigurer(AmazonElastiCache amazonElastiCache, ResourceIdResolver resourceIdResolver, List<String> cacheNames, List<CacheFactory> cacheFactories) {
        this.cacheNames = cacheNames;
        this.amazonElastiCache = amazonElastiCache;
        this.resourceIdResolver = resourceIdResolver;
        this.cacheFactories = cacheFactories;
    }

    public CacheManager cacheManager() {
        ArrayList<Cache> caches = new ArrayList<Cache>(this.cacheNames.size());
        for (String cacheName : this.cacheNames) {
            caches.add(this.clusterCache(cacheName));
        }
        SimpleCacheManager simpleCacheManager = new SimpleCacheManager();
        simpleCacheManager.setCaches(caches);
        simpleCacheManager.afterPropertiesSet();
        return simpleCacheManager;
    }

    protected Cache clusterCache(String cacheName) {
        try {
            ElastiCacheFactoryBean cacheFactoryBean = new ElastiCacheFactoryBean(this.amazonElastiCache, cacheName, this.resourceIdResolver, this.cacheFactories);
            cacheFactoryBean.afterPropertiesSet();
            return (Cache)cacheFactoryBean.getObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating cache", e);
        }
    }
}

