/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.context.config.xml;

import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.core.env.StackResourceRegistryDetectingResourceIdResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public final class GlobalBeanDefinitionUtils {
    public static final String RESOURCE_ID_RESOLVER_BEAN_NAME = ResourceIdResolver.class.getName() + ".BEAN_NAME";

    private GlobalBeanDefinitionUtils() {
    }

    public static String retrieveResourceIdResolverBeanName(BeanDefinitionRegistry registry) {
        GlobalBeanDefinitionUtils.registerResourceIdResolverBeanIfNeeded(registry);
        return RESOURCE_ID_RESOLVER_BEAN_NAME;
    }

    static void registerResourceIdResolverBeanIfNeeded(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition(RESOURCE_ID_RESOLVER_BEAN_NAME)) {
            registry.registerBeanDefinition(RESOURCE_ID_RESOLVER_BEAN_NAME, GlobalBeanDefinitionUtils.buildResourceIdResolverBeanDefinition());
        }
    }

    private static BeanDefinition buildResourceIdResolverBeanDefinition() {
        return BeanDefinitionBuilder.genericBeanDefinition(StackResourceRegistryDetectingResourceIdResolver.class).getBeanDefinition();
    }
}

