/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.s3;

import io.awspring.cloud.autoconfigure.config.s3.S3PropertySources;
import java.util.Objects;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.core.style.ToStringCreator;

public class S3ConfigDataResource
extends ConfigDataResource {
    private final String context;
    private final boolean enabled;
    private final boolean optional;
    private final S3PropertySources propertySources;

    public S3ConfigDataResource(String context, boolean optional, S3PropertySources propertySources) {
        this(context, optional, true, propertySources);
    }

    public S3ConfigDataResource(String context, boolean optional, boolean enabled, S3PropertySources propertySources) {
        this.context = context;
        this.optional = optional;
        this.propertySources = propertySources;
        this.enabled = enabled;
    }

    public String getContext() {
        return this.context;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public S3PropertySources getPropertySources() {
        return this.propertySources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        S3ConfigDataResource that = (S3ConfigDataResource)((Object)o);
        return this.optional == that.optional && this.context.equals(that.context);
    }

    public int hashCode() {
        return Objects.hash(this.optional, this.context);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("context", (Object)this.context).append("optional", this.optional).toString();
    }
}

