/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.s3;

import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.autoconfigure.s3.S3TransferManagerAutoConfiguration;
import io.awspring.cloud.autoconfigure.s3.properties.S3CrtClientProperties;
import io.awspring.cloud.autoconfigure.s3.properties.S3Properties;
import java.util.Optional;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.crt.s3.S3Client;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3CrtAsyncClientBuilder;

@AutoConfiguration
@ConditionalOnClass(value={S3Client.class, S3AsyncClient.class})
@EnableConfigurationProperties(value={S3Properties.class})
@ConditionalOnProperty(name={"spring.cloud.aws.s3.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={S3TransferManagerAutoConfiguration.class})
public class S3CrtAsyncClientAutoConfiguration {
    private final S3Properties properties;
    private final AwsProperties awsProperties;
    private final AwsClientBuilderConfigurer awsClientBuilderConfigurer;

    public S3CrtAsyncClientAutoConfiguration(S3Properties properties, AwsProperties awsProperties, AwsClientBuilderConfigurer awsClientBuilderConfigurer) {
        this.properties = properties;
        this.awsProperties = awsProperties;
        this.awsClientBuilderConfigurer = awsClientBuilderConfigurer;
    }

    @Bean
    @ConditionalOnMissingBean
    S3AsyncClient s3AsyncClient(AwsCredentialsProvider credentialsProvider) {
        S3CrtAsyncClientBuilder builder = S3AsyncClient.crtBuilder().credentialsProvider(credentialsProvider).region(this.awsClientBuilderConfigurer.resolveRegion(this.properties));
        Optional.ofNullable(this.awsProperties.getEndpoint()).ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).endpointOverride(arg_0));
        Optional.ofNullable(this.properties.getEndpoint()).ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).endpointOverride(arg_0));
        Optional.ofNullable(this.properties.getCrossRegionEnabled()).ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).crossRegionAccessEnabled(arg_0));
        Optional.ofNullable(this.properties.getPathStyleAccessEnabled()).ifPresent(arg_0 -> ((S3CrtAsyncClientBuilder)builder).forcePathStyle(arg_0));
        if (this.properties.getCrt() != null) {
            S3CrtClientProperties crt = this.properties.getCrt();
            PropertyMapper propertyMapper = PropertyMapper.get();
            propertyMapper.from(crt::getMaxConcurrency).whenNonNull().to(arg_0 -> ((S3CrtAsyncClientBuilder)builder).maxConcurrency(arg_0));
            propertyMapper.from(crt::getTargetThroughputInGbps).whenNonNull().to(arg_0 -> ((S3CrtAsyncClientBuilder)builder).targetThroughputInGbps(arg_0));
            propertyMapper.from(crt::getMinimumPartSizeInBytes).whenNonNull().to(arg_0 -> ((S3CrtAsyncClientBuilder)builder).minimumPartSizeInBytes(arg_0));
            propertyMapper.from(crt::getInitialReadBufferSizeInBytes).whenNonNull().to(arg_0 -> ((S3CrtAsyncClientBuilder)builder).initialReadBufferSizeInBytes(arg_0));
        }
        return builder.build();
    }
}

