/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.s3;

import io.awspring.cloud.autoconfigure.core.AwsClientBuilderConfigurer;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.autoconfigure.s3.S3AutoConfiguration;
import io.awspring.cloud.autoconfigure.s3.properties.S3Properties;
import io.awspring.cloud.autoconfigure.s3.properties.S3TransferManagerProperties;
import io.awspring.cloud.s3.PropertiesS3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.TransferManagerS3OutputStreamProvider;
import java.util.Optional;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.transfer.s3.S3ClientConfiguration;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.S3TransferManagerOverrideConfiguration;
import software.amazon.awssdk.transfer.s3.UploadDirectoryOverrideConfiguration;

@AutoConfiguration
@ConditionalOnClass(value={S3TransferManager.class, S3OutputStreamProvider.class})
@EnableConfigurationProperties(value={S3Properties.class})
@ConditionalOnProperty(name={"spring.cloud.aws.s3.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureBefore(value={S3AutoConfiguration.class})
public class S3TransferManagerAutoConfiguration {
    private final S3Properties properties;
    private final AwsProperties awsProperties;
    private final AwsCredentialsProvider credentialsProvider;
    private final AwsClientBuilderConfigurer awsClientBuilderConfigurer;

    public S3TransferManagerAutoConfiguration(S3Properties properties, AwsProperties awsProperties, AwsCredentialsProvider credentialsProvider, AwsClientBuilderConfigurer awsClientBuilderConfigurer) {
        this.properties = properties;
        this.awsProperties = awsProperties;
        this.credentialsProvider = credentialsProvider;
        this.awsClientBuilderConfigurer = awsClientBuilderConfigurer;
    }

    @Bean
    @ConditionalOnMissingBean
    S3TransferManager s3TransferManager() {
        return S3TransferManager.builder().s3ClientConfiguration(this.s3ClientConfiguration()).transferConfiguration(this.extractUploadDirectoryOverrideConfiguration()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    S3OutputStreamProvider transferManagerS3StreamProvider(S3TransferManager s3TransferManager, Optional<S3ObjectContentTypeResolver> contentTypeResolver) {
        return new TransferManagerS3OutputStreamProvider(s3TransferManager, contentTypeResolver.orElseGet(PropertiesS3ObjectContentTypeResolver::new));
    }

    private S3ClientConfiguration s3ClientConfiguration() {
        S3ClientConfiguration.Builder builder = this.configure(S3ClientConfiguration.builder());
        if (this.properties.getTransferManager() != null) {
            S3TransferManagerProperties transferManagerProperties = this.properties.getTransferManager();
            PropertyMapper propertyMapper = PropertyMapper.get();
            propertyMapper.from(transferManagerProperties::getMaxConcurrency).whenNonNull().to(arg_0 -> ((S3ClientConfiguration.Builder)builder).maxConcurrency(arg_0));
            propertyMapper.from(transferManagerProperties::getTargetThroughputInGbps).whenNonNull().to(arg_0 -> ((S3ClientConfiguration.Builder)builder).targetThroughputInGbps(arg_0));
            propertyMapper.from(transferManagerProperties::getMinimumPartSizeInBytes).whenNonNull().to(arg_0 -> ((S3ClientConfiguration.Builder)builder).minimumPartSizeInBytes(arg_0));
        }
        return (S3ClientConfiguration)builder.build();
    }

    private S3ClientConfiguration.Builder configure(S3ClientConfiguration.Builder builder) {
        builder.credentialsProvider(this.credentialsProvider).region(this.awsClientBuilderConfigurer.resolveRegion(this.properties));
        Optional.ofNullable(this.awsProperties.getEndpoint()).ifPresent(arg_0 -> ((S3ClientConfiguration.Builder)builder).endpointOverride(arg_0));
        Optional.ofNullable(this.properties.getEndpoint()).ifPresent(arg_0 -> ((S3ClientConfiguration.Builder)builder).endpointOverride(arg_0));
        return builder;
    }

    private S3TransferManagerOverrideConfiguration extractUploadDirectoryOverrideConfiguration() {
        UploadDirectoryOverrideConfiguration.Builder config = UploadDirectoryOverrideConfiguration.builder();
        if (this.properties.getTransferManager() != null && this.properties.getTransferManager().getUploadDirectory() != null) {
            S3TransferManagerProperties.S3UploadDirectoryProperties s3UploadDirectoryProperties = this.properties.getTransferManager().getUploadDirectory();
            PropertyMapper propertyMapper = PropertyMapper.get();
            propertyMapper.from(s3UploadDirectoryProperties::getMaxDepth).whenNonNull().to(arg_0 -> ((UploadDirectoryOverrideConfiguration.Builder)config).maxDepth(arg_0));
            propertyMapper.from(s3UploadDirectoryProperties::getRecursive).whenNonNull().to(arg_0 -> ((UploadDirectoryOverrideConfiguration.Builder)config).recursive(arg_0));
            propertyMapper.from(s3UploadDirectoryProperties::getFollowSymbolicLinks).whenNonNull().to(arg_0 -> ((UploadDirectoryOverrideConfiguration.Builder)config).followSymbolicLinks(arg_0));
        }
        return (S3TransferManagerOverrideConfiguration)S3TransferManagerOverrideConfiguration.builder().uploadDirectoryConfiguration(config.build()).build();
    }
}

