/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.core;

import io.awspring.cloud.autoconfigure.core.Profile;
import io.awspring.cloud.autoconfigure.core.RegionProperties;
import io.awspring.cloud.core.region.StaticRegionProvider;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.providers.AwsProfileRegionProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;
import software.amazon.awssdk.regions.providers.AwsRegionProviderChain;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.regions.providers.InstanceProfileRegionProvider;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={StaticRegionProvider.class, AwsRegionProvider.class, ProfileFile.class})
@EnableConfigurationProperties(value={RegionProperties.class})
public class RegionProviderAutoConfiguration {
    private final RegionProperties properties;

    public RegionProviderAutoConfiguration(RegionProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public AwsRegionProvider regionProvider() {
        return RegionProviderAutoConfiguration.createRegionProvider(this.properties);
    }

    public static AwsRegionProvider createRegionProvider(RegionProperties properties) {
        Profile profile;
        ArrayList<Object> providers = new ArrayList<Object>();
        if (properties.getStatic() != null && properties.isStatic()) {
            providers.add(new StaticRegionProvider(properties.getStatic()));
        }
        if (properties.isInstanceProfile()) {
            providers.add(new InstanceProfileRegionProvider());
        }
        if ((profile = properties.getProfile()) != null && profile.getName() != null) {
            providers.add(RegionProviderAutoConfiguration.createProfileRegionProvider(profile));
        }
        if (providers.isEmpty()) {
            return DefaultAwsRegionProviderChain.builder().build();
        }
        return new AwsRegionProviderChain(providers.toArray(new AwsRegionProvider[0]));
    }

    private static AwsProfileRegionProvider createProfileRegionProvider(Profile profile) {
        Supplier<ProfileFile> profileFileFn = () -> {
            if (profile.getPath() != null) {
                return ProfileFile.builder().type(ProfileFile.Type.CONFIGURATION).content(Paths.get(profile.getPath(), new String[0])).build();
            }
            return ProfileFile.defaultProfileFile();
        };
        return new AwsProfileRegionProvider(profileFileFn, profile.getName());
    }
}

