/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.security;

import io.awspring.cloud.autoconfigure.security.CognitoAuthenticationProperties;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={OAuth2ResourceServerAutoConfiguration.class})
@EnableConfigurationProperties(value={CognitoAuthenticationProperties.class})
@ConditionalOnProperty(prefix="spring.cloud.aws.security.cognito", name={"enabled"}, matchIfMissing=true)
@Conditional(value={OnUserPoolIdAndRegionPropertiesCondition.class})
public class CognitoAuthenticationAutoConfiguration {
    private final CognitoAuthenticationProperties properties;

    public CognitoAuthenticationAutoConfiguration(CognitoAuthenticationProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"cognitoJwtDelegatingValidator"})
    public DelegatingOAuth2TokenValidator<Jwt> cognitoJwtDelegatingValidator() {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(JwtValidators.createDefaultWithIssuer((String)this.properties.getIssuer()));
        validators.add(new JwtClaimValidator("aud", aud -> aud != null && aud.contains(this.properties.getAppClientId())));
        return new DelegatingOAuth2TokenValidator(validators);
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtDecoder cognitoJwtDecoder(@Qualifier(value="cognitoJwtDelegatingValidator") DelegatingOAuth2TokenValidator<Jwt> validator) {
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)this.properties.getRegistry()).jwsAlgorithm(SignatureAlgorithm.from((String)this.properties.getAlgorithm())).build();
        jwtDecoder.setJwtValidator(validator);
        return jwtDecoder;
    }

    static class OnUserPoolIdAndRegionPropertiesCondition
    extends AllNestedConditions {
        OnUserPoolIdAndRegionPropertiesCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"spring.cloud.aws.security.cognito.region"})
        static class HasRegionProperty {
            HasRegionProperty() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.aws.security.cognito.user-pool-id"})
        static class HasUserPoolIdProperty {
            HasUserPoolIdProperty() {
            }
        }
    }
}

