/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.mail;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import io.awspring.cloud.autoconfigure.context.ContextCredentialsAutoConfiguration;
import io.awspring.cloud.autoconfigure.mail.SesProperties;
import io.awspring.cloud.autoconfigure.mail.SimpleEmailAutoConfiguration;
import io.awspring.cloud.context.annotation.ConditionalOnMissingAmazonClient;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.region.RegionProvider;
import io.awspring.cloud.core.region.StaticRegionProvider;
import io.awspring.cloud.ses.SimpleEmailServiceJavaMailSender;
import io.awspring.cloud.ses.SimpleEmailServiceMailSender;
import javax.mail.Session;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={MailSenderAutoConfiguration.class})
@AutoConfigureBefore(value={SimpleEmailAutoConfiguration.class})
@ConditionalOnClass(value={AmazonSimpleEmailService.class, MailSender.class, SimpleEmailServiceJavaMailSender.class})
@ConditionalOnMissingBean(value={MailSender.class})
@Import(value={ContextCredentialsAutoConfiguration.class})
@EnableConfigurationProperties(value={SesProperties.class})
@ConditionalOnProperty(name={"spring.cloud.aws.ses.enabled"}, havingValue="true", matchIfMissing=true)
public class SesAutoConfiguration {
    private final AWSCredentialsProvider credentialsProvider;
    private final RegionProvider regionProvider;
    private final ClientConfiguration clientConfiguration;

    public SesAutoConfiguration(ObjectProvider<RegionProvider> regionProvider, ObjectProvider<AWSCredentialsProvider> credentialsProvider, @Qualifier(value="com.amazonaws.ClientConfiguration.BEAN_NAME") ObjectProvider<ClientConfiguration> globalClientConfiguration, @Qualifier(value="sesClientConfiguration") ObjectProvider<ClientConfiguration> sesClientConfiguration, SesProperties properties) {
        this.credentialsProvider = (AWSCredentialsProvider)credentialsProvider.getIfAvailable();
        this.regionProvider = properties.getRegion() == null ? (RegionProvider)regionProvider.getIfAvailable() : new StaticRegionProvider(properties.getRegion());
        this.clientConfiguration = (ClientConfiguration)sesClientConfiguration.getIfAvailable(() -> globalClientConfiguration.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonSimpleEmailService.class)
    public AmazonWebserviceClientFactoryBean<AmazonSimpleEmailServiceClient> amazonSimpleEmailService() {
        return new AmazonWebserviceClientFactoryBean(AmazonSimpleEmailServiceClient.class, this.credentialsProvider, this.regionProvider, this.clientConfiguration);
    }

    @Bean
    @ConditionalOnMissingClass(value={"javax.mail.Session"})
    public MailSender simpleMailSender(AmazonSimpleEmailService amazonSimpleEmailService) {
        return new SimpleEmailServiceMailSender(amazonSimpleEmailService);
    }

    @Bean
    @ConditionalOnClass(value={Session.class})
    public JavaMailSender javaMailSender(AmazonSimpleEmailService amazonSimpleEmailService) {
        return new SimpleEmailServiceJavaMailSender(amazonSimpleEmailService);
    }
}

