/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.context;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.AmazonCloudFormationClient;
import com.amazonaws.services.ec2.AmazonEC2;
import io.awspring.cloud.autoconfigure.context.ContextCredentialsAutoConfiguration;
import io.awspring.cloud.autoconfigure.context.properties.AwsStackProperties;
import io.awspring.cloud.context.annotation.ConditionalOnMissingAmazonClient;
import io.awspring.cloud.context.config.annotation.ContextDefaultConfigurationRegistrar;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.env.stack.StackResourceRegistry;
import io.awspring.cloud.core.env.stack.config.AutoDetectingStackNameProvider;
import io.awspring.cloud.core.env.stack.config.StackNameProvider;
import io.awspring.cloud.core.env.stack.config.StackResourceRegistryFactoryBean;
import io.awspring.cloud.core.env.stack.config.StaticStackNameProvider;
import io.awspring.cloud.core.region.RegionProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@Import(value={ContextCredentialsAutoConfiguration.class, ContextDefaultConfigurationRegistrar.class})
@ConditionalOnClass(name={"com.amazonaws.services.cloudformation.AmazonCloudFormation"})
@EnableConfigurationProperties(value={AwsStackProperties.class})
@ConditionalOnProperty(name={"cloud.aws.stack.enabled"}, havingValue="true", matchIfMissing=true)
public class ContextStackAutoConfiguration {
    private final AwsStackProperties properties;

    public ContextStackAutoConfiguration(AwsStackProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"cloud.aws.stack.name"})
    public StackNameProvider staticStackNameProvider() {
        return new StaticStackNameProvider(this.properties.getName());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"cloud.aws.stack.auto"}, havingValue="true", matchIfMissing=true)
    public StackNameProvider autoDetectingStackNameProvider(AmazonCloudFormation amazonCloudFormation, ObjectProvider<AmazonEC2> amazonEC2) {
        return new AutoDetectingStackNameProvider(amazonCloudFormation, (AmazonEC2)amazonEC2.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean(value={StackResourceRegistry.class})
    @ConditionalOnBean(value={StackNameProvider.class})
    public StackResourceRegistryFactoryBean stackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormation, StackNameProvider stackNameProvider) {
        return new StackResourceRegistryFactoryBean(amazonCloudFormation, stackNameProvider);
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonCloudFormation.class)
    public AmazonWebserviceClientFactoryBean<AmazonCloudFormationClient> amazonCloudFormation(ObjectProvider<RegionProvider> regionProvider, ObjectProvider<AWSCredentialsProvider> credentialsProvider) {
        return new AmazonWebserviceClientFactoryBean(AmazonCloudFormationClient.class, (AWSCredentialsProvider)credentialsProvider.getIfAvailable(), (RegionProvider)regionProvider.getIfAvailable());
    }
}

