/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.classpath;

import io.avaje.classpath.scanner.FilterResource;
import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.core.Location;
import io.avaje.classpath.scanner.internal.EnvironmentDetection;
import io.avaje.classpath.scanner.internal.ResourceAndClassScanner;
import io.avaje.classpath.scanner.internal.ScanLog;
import io.avaje.classpath.scanner.internal.UrlUtils;
import io.avaje.classpath.scanner.internal.scanner.classpath.ClassPathLocationScanner;
import io.avaje.classpath.scanner.internal.scanner.classpath.ClassPathResource;
import io.avaje.classpath.scanner.internal.scanner.classpath.DefaultUrlResolver;
import io.avaje.classpath.scanner.internal.scanner.classpath.FileSystemClassPathLocationScanner;
import io.avaje.classpath.scanner.internal.scanner.classpath.JarFileClassPathLocationScanner;
import io.avaje.classpath.scanner.internal.scanner.classpath.OsgiClassPathLocationScanner;
import io.avaje.classpath.scanner.internal.scanner.classpath.UrlResolver;
import io.avaje.classpath.scanner.internal.scanner.classpath.jboss.JBossVFSv2UrlResolver;
import io.avaje.classpath.scanner.internal.scanner.classpath.jboss.JBossVFSv3ClassPathLocationScanner;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

public class ClassPathScanner
implements ResourceAndClassScanner {
    private static final System.Logger log = ScanLog.log;
    private final ClassLoader classLoader;
    private final Map<Location, List<URL>> locationUrlCache = new HashMap<Location, List<URL>>();
    private final Map<String, ClassPathLocationScanner> locationScannerCache = new HashMap<String, ClassPathLocationScanner>();
    private final Map<ClassPathLocationScanner, Map<URL, Set<String>>> resourceNameCache = new HashMap<ClassPathLocationScanner, Map<URL, Set<String>>>();
    private final boolean websphere;

    public ClassPathScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.websphere = classLoader.getClass().getName().startsWith("com.ibm");
    }

    @Override
    public List<Resource> scanForResources(Location path, Predicate<String> predicate) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String resourceName : this.findResourceNames(path, predicate)) {
                resources.add(new ClassPathResource(resourceName, this.classLoader));
            }
            return resources;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public List<Class<?>> scanForClasses(Location location, Predicate<Class<?>> predicate) {
        try {
            ArrayList classes = new ArrayList();
            Set<String> resourceNames = this.findResourceNames(location, FilterResource.bySuffix((String)".class"));
            log.log(System.Logger.Level.TRACE, "scan for classes at {0} found {1}", location, resourceNames.size());
            for (String resourceName : resourceNames) {
                String className = this.toClassName(resourceName);
                try {
                    Class<?> clazz;
                    if ("module-info".equals(className) || !predicate.test(clazz = this.classLoader.loadClass(className))) continue;
                    classes.add(clazz);
                }
                catch (ClassNotFoundException | NoClassDefFoundError err) {
                    log.log(System.Logger.Level.DEBUG, "class " + className + " not loaded and will be ignored", err);
                }
            }
            return classes;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    private Set<String> findResourceNames(Location location, Predicate<String> predicate) throws IOException {
        TreeSet<String> resourceNames = new TreeSet<String>();
        List<URL> locationsUrls = this.locationUrlsForPath(location);
        for (URL locationUrl : locationsUrls) {
            log.log(System.Logger.Level.TRACE, "scan {0}", locationUrl.toExternalForm());
            UrlResolver urlResolver = this.createUrlResolver(locationUrl.getProtocol());
            URL resolvedUrl = urlResolver.toStandardJavaUrl(locationUrl);
            String protocol = resolvedUrl.getProtocol();
            ClassPathLocationScanner classPathLocationScanner = this.createLocationScanner(protocol);
            if (classPathLocationScanner == null) {
                String scanRoot = UrlUtils.toFilePath(resolvedUrl);
                log.log(System.Logger.Level.WARNING, "Unable to scan location: {0} (unsupported protocol: {1})", scanRoot, protocol);
                continue;
            }
            Set<String> names = this.resourceNameCache.get(classPathLocationScanner).get(resolvedUrl);
            if (names == null) {
                names = classPathLocationScanner.findResourceNames(location.path(), resolvedUrl);
                this.resourceNameCache.get(classPathLocationScanner).put(resolvedUrl, names);
            }
            resourceNames.addAll(names);
        }
        return this.filterResourceNames(resourceNames, predicate);
    }

    private List<URL> locationUrlsForPath(Location location) throws IOException {
        List<URL> urls = this.locationUrlCache.get(location);
        if (urls != null) {
            return urls;
        }
        ArrayList<URL> locationUrls = new ArrayList<URL>();
        if (this.websphere) {
            this.loadWebsphereUrls(location, locationUrls);
        } else {
            this.loadLocationUrls(location, locationUrls);
        }
        this.locationUrlCache.put(location, locationUrls);
        return locationUrls;
    }

    private void loadLocationUrls(Location location, List<URL> locationUrls) throws IOException {
        Enumeration<URL> urls = this.classLoader.getResources(location.path());
        while (urls.hasMoreElements()) {
            locationUrls.add(urls.nextElement());
        }
    }

    private void loadWebsphereUrls(Location location, List<URL> locationUrls) throws IOException {
        Enumeration<URL> urls = this.classLoader.getResources(location.toString());
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            locationUrls.add(new URL(URLDecoder.decode(url.toExternalForm(), StandardCharsets.UTF_8)));
        }
    }

    private UrlResolver createUrlResolver(String protocol) {
        if (new EnvironmentDetection(this.classLoader).isJBossVFSv2() && protocol.startsWith("vfs")) {
            return new JBossVFSv2UrlResolver();
        }
        return new DefaultUrlResolver();
    }

    private ClassPathLocationScanner createLocationScanner(String protocol) {
        ClassPathLocationScanner scanner = this.locationScannerCache.get(protocol);
        if (scanner != null) {
            return scanner;
        }
        if ("file".equals(protocol)) {
            FileSystemClassPathLocationScanner locationScanner = new FileSystemClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        if ("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol)) {
            JarFileClassPathLocationScanner locationScanner = new JarFileClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        EnvironmentDetection featureDetector = new EnvironmentDetection(this.classLoader);
        if (featureDetector.isJBossVFSv3() && "vfs".equals(protocol)) {
            JBossVFSv3ClassPathLocationScanner locationScanner = new JBossVFSv3ClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        if (featureDetector.isOsgi() && ("bundle".equals(protocol) || "bundleresource".equals(protocol))) {
            OsgiClassPathLocationScanner locationScanner = new OsgiClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        return null;
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, Predicate<String> predicate) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            if (!predicate.test(resourceName)) continue;
            filteredResourceNames.add(resourceName);
        }
        return filteredResourceNames;
    }
}

