/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.ByteBufferBuffer;
import io.atomix.catalyst.buffer.MappedBytes;
import java.io.File;
import java.nio.channels.FileChannel;

public class MappedBuffer
extends ByteBufferBuffer {
    public static MappedBuffer allocate(File file) {
        return MappedBuffer.allocate(file, FileChannel.MapMode.READ_WRITE, 4096L, Long.MAX_VALUE);
    }

    public static MappedBuffer allocate(File file, FileChannel.MapMode mode) {
        return MappedBuffer.allocate(file, mode, 4096L, Long.MAX_VALUE);
    }

    public static MappedBuffer allocate(File file, long capacity) {
        return MappedBuffer.allocate(file, FileChannel.MapMode.READ_WRITE, capacity, capacity);
    }

    public static MappedBuffer allocate(File file, FileChannel.MapMode mode, long capacity) {
        return MappedBuffer.allocate(file, mode, capacity, capacity);
    }

    public static MappedBuffer allocate(File file, long initialCapacity, long maxCapacity) {
        return MappedBuffer.allocate(file, FileChannel.MapMode.READ_WRITE, initialCapacity, maxCapacity);
    }

    public static MappedBuffer allocate(File file, FileChannel.MapMode mode, long initialCapacity, long maxCapacity) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = FileChannel.MapMode.READ_WRITE;
        }
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity cannot be greater than maximum capacity");
        }
        if (initialCapacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("initial capacity for MappedBuffer cannot be greater than 2147483647");
        }
        if (maxCapacity > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maximum capacity for MappedBuffer cannot be greater than 2147483647");
        }
        return new MappedBuffer(MappedBytes.allocate(file, initialCapacity), 0L, initialCapacity, maxCapacity);
    }

    protected MappedBuffer(MappedBytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
    }

    public void delete() {
        ((MappedBytes)this.bytes).delete();
    }
}

