/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import com.google.common.base.Preconditions;
import io.atomix.utils.concurrent.AbstractThreadContext;
import io.atomix.utils.concurrent.AtomixThread;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.Threads;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadContext
extends AbstractThreadContext {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SingleThreadContext.class);
    private final ScheduledExecutorService executor;
    private final Executor wrappedExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            try {
                SingleThreadContext.this.executor.execute(command);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    };

    public SingleThreadContext(String nameFormat) {
        this(Threads.namedThreads(nameFormat, LOGGER));
    }

    public SingleThreadContext(ThreadFactory factory) {
        this(new ScheduledThreadPoolExecutor(1, factory));
    }

    protected SingleThreadContext(ScheduledExecutorService executor) {
        this(SingleThreadContext.getThread(executor), executor);
    }

    private SingleThreadContext(Thread thread, ScheduledExecutorService executor) {
        this.executor = executor;
        Preconditions.checkState((boolean)(thread instanceof AtomixThread), (Object)"not a Catalyst thread");
        ((AtomixThread)thread).setContext(this);
    }

    protected static AtomixThread getThread(ExecutorService executor) {
        AtomicReference thread = new AtomicReference();
        try {
            executor.submit(() -> thread.set((AtomixThread)Thread.currentThread())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to initialize thread state", e);
        }
        return (AtomixThread)thread.get();
    }

    @Override
    public void execute(Runnable command) {
        this.wrappedExecutor.execute(command);
    }

    @Override
    public Scheduled schedule(Duration delay, Runnable runnable) {
        ScheduledFuture<?> future = this.executor.schedule(runnable, delay.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public Scheduled schedule(Duration delay, Duration interval, Runnable runnable) {
        ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(runnable, delay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }
}

