/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import com.google.common.base.Preconditions;
import io.atomix.utils.concurrent.AtomixThread;
import io.atomix.utils.concurrent.Scheduler;
import java.util.concurrent.Executor;

public interface ThreadContext
extends AutoCloseable,
Executor,
Scheduler {
    public static ThreadContext currentContext() {
        Thread thread = Thread.currentThread();
        return thread instanceof AtomixThread ? ((AtomixThread)thread).getContext() : null;
    }

    public static ThreadContext currentContextOrThrow() {
        ThreadContext context = ThreadContext.currentContext();
        Preconditions.checkState((context != null ? 1 : 0) != 0, (Object)"not on a Catalyst thread");
        return context;
    }

    default public boolean isCurrentContext() {
        return ThreadContext.currentContext() == this;
    }

    default public void checkThread() {
        Preconditions.checkState((ThreadContext.currentContext() == this ? 1 : 0) != 0, (Object)"not on a Catalyst thread");
    }

    public boolean isBlocked();

    public void block();

    public void unblock();

    @Override
    public void close();
}

