/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.misc;

import com.google.common.base.Preconditions;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.ThreadContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SlidingWindowCounter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile int headSlot;
    private final int windowSlots;
    private final List<AtomicLong> counters;
    private final Scheduled schedule;
    private static final int SLIDE_WINDOW_PERIOD_SECONDS = 1;

    public SlidingWindowCounter(int windowSlots, ThreadContext context) {
        Preconditions.checkArgument((windowSlots > 0 ? 1 : 0) != 0, (Object)"Window size must be a positive integer");
        this.windowSlots = windowSlots;
        this.headSlot = 0;
        this.counters = Collections.nCopies(windowSlots, 0).stream().map(AtomicLong::new).collect(Collectors.toCollection(ArrayList::new));
        this.schedule = context.schedule(0L, 1L, TimeUnit.SECONDS, this::advanceHead);
    }

    public void destroy() {
        this.schedule.cancel();
    }

    public void incrementCount() {
        this.incrementCount(this.headSlot, 1L);
    }

    public void incrementCount(long value) {
        this.incrementCount(this.headSlot, value);
    }

    private void incrementCount(int slot, long value) {
        this.counters.get(slot).addAndGet(value);
    }

    public long get(int slots) {
        Preconditions.checkArgument((slots <= this.windowSlots ? 1 : 0) != 0, (Object)"Requested window must be less than the total window slots");
        long sum = 0L;
        for (int i = 0; i < slots; ++i) {
            int currentIndex = this.headSlot - i;
            if (currentIndex < 0) {
                currentIndex = this.counters.size() + currentIndex;
            }
            sum += this.counters.get(currentIndex).get();
        }
        return sum;
    }

    void advanceHead() {
        this.counters.get(this.slotAfter(this.headSlot)).set(0L);
        this.headSlot = this.slotAfter(this.headSlot);
    }

    private int slotAfter(int slot) {
        return (slot + 1) % this.windowSlots;
    }
}

