/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import io.atomix.utils.concurrent.AtomixFuture;
import io.atomix.utils.concurrent.OrderedFuture;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Futures {
    public static <T> CompletableFuture<T> completedFuture(T result) {
        return CompletableFuture.completedFuture(result);
    }

    public static <T> CompletableFuture<T> completedFutureAsync(T result, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> future.complete(result));
        return future;
    }

    public static <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static <T> CompletableFuture<T> exceptionalFutureAsync(Throwable t, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> future.completeExceptionally(t));
        return future;
    }

    public static <T> CompletableFuture<T> orderedFuture() {
        return new OrderedFuture();
    }

    public static <T> CompletableFuture<T> orderedFuture(CompletableFuture<T> future) {
        OrderedFuture newFuture = new OrderedFuture();
        future.whenComplete((r, e) -> {
            if (e == null) {
                newFuture.complete(r);
            } else {
                newFuture.completeExceptionally((Throwable)e);
            }
        });
        return newFuture;
    }

    public static <T> CompletableFuture<T> asyncFuture(CompletableFuture<T> future, Executor executor) {
        AtomixFuture newFuture = new AtomixFuture();
        future.whenComplete((result, error) -> executor.execute(() -> {
            if (error == null) {
                newFuture.complete(result);
            } else {
                newFuture.completeExceptionally((Throwable)error);
            }
        }));
        return newFuture;
    }

    public static <T> CompletableFuture<Stream<T>> allOf(Stream<CompletableFuture<T>> futures) {
        CompletableFuture[] futuresArray = (CompletableFuture[])futures.toArray(CompletableFuture[]::new);
        return AtomixFuture.wrap(CompletableFuture.allOf(futuresArray).thenApply(v -> Stream.of(futuresArray).map(CompletableFuture::join)));
    }

    public static <T> CompletableFuture<List<T>> allOf(List<CompletableFuture<T>> futures) {
        return AtomixFuture.wrap(CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList())));
    }

    public static <T> CompletableFuture<T> allOf(List<CompletableFuture<T>> futures, BinaryOperator<T> reducer, T emptyValue) {
        return Futures.allOf(futures).thenApply(resultList -> resultList.stream().reduce(reducer).orElse(emptyValue));
    }
}

