/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import com.google.common.collect.Lists;
import io.atomix.utils.Match;
import io.atomix.utils.concurrent.BlockingAwareFuture;
import io.atomix.utils.concurrent.OrderedFuture;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

public final class Futures {
    public static <T> CompletableFuture<T> completedFuture(T result) {
        return CompletableFuture.completedFuture(result);
    }

    public static <T> CompletableFuture<T> completedFutureAsync(T result, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> future.complete(result));
        return future;
    }

    public static <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static <T> CompletableFuture<T> exceptionalFutureAsync(Throwable t, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> future.completeExceptionally(t));
        return future;
    }

    public static <T> CompletableFuture<T> orderedFuture() {
        return new OrderedFuture();
    }

    public static <T> CompletableFuture<T> asyncFuture(CompletableFuture<T> future, Executor executor) {
        CompletableFuture newFuture = new CompletableFuture();
        future.whenComplete((result, error) -> executor.execute(() -> {
            if (error == null) {
                newFuture.complete(result);
            } else {
                newFuture.completeExceptionally((Throwable)error);
            }
        }));
        return newFuture;
    }

    public static <T> CompletableFuture<T> blockingAwareFuture(CompletableFuture<T> future, Executor executor) {
        if (future.isDone()) {
            return future;
        }
        BlockingAwareFuture newFuture = new BlockingAwareFuture();
        future.whenComplete((result, error) -> {
            if (newFuture.isBlocked()) {
                if (error == null) {
                    newFuture.complete(result);
                } else {
                    newFuture.completeExceptionally((Throwable)error);
                }
            } else if (error == null) {
                executor.execute(() -> newFuture.complete(result));
            } else {
                executor.execute(() -> newFuture.completeExceptionally((Throwable)error));
            }
        });
        return newFuture;
    }

    public static <T> CompletableFuture<List<T>> allOf(List<CompletableFuture<T>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> CompletableFuture<T> allOf(List<CompletableFuture<T>> futures, BinaryOperator<T> reducer, T emptyValue) {
        return Futures.allOf(futures).thenApply(resultList -> resultList.stream().reduce(reducer).orElse(emptyValue));
    }

    public static <T> CompletableFuture<T> firstOf(List<CompletableFuture<T>> futures, Match<T> positiveResultMatcher, T negativeResult) {
        CompletableFuture responseFuture = new CompletableFuture();
        Futures.allOf(Lists.transform(futures, future -> future.thenAccept(r -> {
            if (positiveResultMatcher.matches(r)) {
                responseFuture.complete(r);
            }
        }))).whenComplete((r, e) -> {
            if (!responseFuture.isDone()) {
                if (e != null) {
                    responseFuture.completeExceptionally((Throwable)e);
                } else {
                    responseFuture.complete(negativeResult);
                }
            }
        });
        return responseFuture;
    }
}

