/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import io.atomix.utils.concurrent.BlockingAwareFuture;
import io.atomix.utils.concurrent.OrderedFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public final class Futures {
    public static <T> CompletableFuture<T> completedFuture(T result) {
        return CompletableFuture.completedFuture(result);
    }

    public static <T> CompletableFuture<T> completedFutureAsync(T result, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> future.complete(result));
        return future;
    }

    public static <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static <T> CompletableFuture<T> exceptionalFutureAsync(Throwable t, Executor executor) {
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> future.completeExceptionally(t));
        return future;
    }

    public static <T> CompletableFuture<T> orderedFuture() {
        return new OrderedFuture();
    }

    public static <T> CompletableFuture<T> asyncFuture(CompletableFuture<T> future, Executor executor) {
        CompletableFuture newFuture = new CompletableFuture();
        future.whenComplete((result, error) -> executor.execute(() -> {
            if (error == null) {
                newFuture.complete(result);
            } else {
                newFuture.completeExceptionally((Throwable)error);
            }
        }));
        return newFuture;
    }

    public static <T> CompletableFuture<T> blockingAwareFuture(CompletableFuture<T> future, Executor executor) {
        if (future.isDone()) {
            return future;
        }
        BlockingAwareFuture newFuture = new BlockingAwareFuture();
        future.whenComplete((result, error) -> {
            if (newFuture.isBlocked()) {
                if (error == null) {
                    newFuture.complete(result);
                } else {
                    newFuture.completeExceptionally((Throwable)error);
                }
            } else if (error == null) {
                executor.execute(() -> newFuture.complete(result));
            } else {
                executor.execute(() -> newFuture.completeExceptionally((Throwable)error));
            }
        });
        return newFuture;
    }
}

