/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.test;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.discovery.ManagedNodeDiscoveryService;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.impl.DefaultClusterMembershipService;
import io.atomix.cluster.impl.DefaultNodeDiscoveryService;
import io.atomix.cluster.messaging.BroadcastService;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.UnicastService;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.HeartbeatMembershipProtocol;
import io.atomix.cluster.protocol.HeartbeatMembershipProtocolConfig;
import io.atomix.primitive.PrimitiveBuilder;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.config.PrimitiveConfig;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.operation.impl.DefaultOperationId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.service.AbstractPrimitiveService;
import io.atomix.primitive.service.BackupInput;
import io.atomix.primitive.service.BackupOutput;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.PrimitiveService;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.service.ServiceExecutor;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.session.CommunicationStrategy;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.protocols.raft.storage.log.entry.CloseSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.CommandEntry;
import io.atomix.protocols.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.protocols.raft.storage.log.entry.InitializeEntry;
import io.atomix.protocols.raft.storage.log.entry.KeepAliveEntry;
import io.atomix.protocols.raft.storage.log.entry.MetadataEntry;
import io.atomix.protocols.raft.storage.log.entry.OpenSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.system.Configuration;
import io.atomix.protocols.raft.test.protocol.LocalRaftProtocolFactory;
import io.atomix.protocols.raft.test.protocol.RaftClientMessagingProtocol;
import io.atomix.protocols.raft.test.protocol.RaftServerMessagingProtocol;
import io.atomix.storage.StorageLevel;
import io.atomix.utils.Version;
import io.atomix.utils.concurrent.ThreadModel;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class RaftPerformanceTest
implements Runnable {
    private static final boolean USE_NETTY = true;
    private static final int ITERATIONS = 1;
    private static final int TOTAL_OPERATIONS = 1000000;
    private static final int WRITE_RATIO = 10;
    private static final int NUM_CLIENTS = 5;
    private static final ReadConsistency READ_CONSISTENCY = ReadConsistency.LINEARIZABLE;
    private static final CommunicationStrategy COMMUNICATION_STRATEGY = CommunicationStrategy.ANY;
    private static final Serializer protocolSerializer = Serializer.using((Namespace)Namespace.builder().register(new Class[]{HeartbeatRequest.class}).register(new Class[]{HeartbeatResponse.class}).register(new Class[]{OpenSessionRequest.class}).register(new Class[]{OpenSessionResponse.class}).register(new Class[]{CloseSessionRequest.class}).register(new Class[]{CloseSessionResponse.class}).register(new Class[]{KeepAliveRequest.class}).register(new Class[]{KeepAliveResponse.class}).register(new Class[]{QueryRequest.class}).register(new Class[]{QueryResponse.class}).register(new Class[]{CommandRequest.class}).register(new Class[]{CommandResponse.class}).register(new Class[]{MetadataRequest.class}).register(new Class[]{MetadataResponse.class}).register(new Class[]{JoinRequest.class}).register(new Class[]{JoinResponse.class}).register(new Class[]{LeaveRequest.class}).register(new Class[]{LeaveResponse.class}).register(new Class[]{ConfigureRequest.class}).register(new Class[]{ConfigureResponse.class}).register(new Class[]{ReconfigureRequest.class}).register(new Class[]{ReconfigureResponse.class}).register(new Class[]{InstallRequest.class}).register(new Class[]{InstallResponse.class}).register(new Class[]{PollRequest.class}).register(new Class[]{PollResponse.class}).register(new Class[]{VoteRequest.class}).register(new Class[]{VoteResponse.class}).register(new Class[]{AppendRequest.class}).register(new Class[]{AppendResponse.class}).register(new Class[]{PublishRequest.class}).register(new Class[]{ResetRequest.class}).register(new Class[]{RaftResponse.Status.class}).register(new Class[]{RaftError.class}).register(new Class[]{RaftError.Type.class}).register(new Class[]{PrimitiveOperation.class}).register(new Class[]{ReadConsistency.class}).register(new Class[]{byte[].class}).register(new Class[]{long[].class}).register(new Class[]{CloseSessionEntry.class}).register(new Class[]{CommandEntry.class}).register(new Class[]{ConfigurationEntry.class}).register(new Class[]{InitializeEntry.class}).register(new Class[]{KeepAliveEntry.class}).register(new Class[]{MetadataEntry.class}).register(new Class[]{OpenSessionEntry.class}).register(new Class[]{QueryEntry.class}).register(new Class[]{PrimitiveOperation.class}).register(new Class[]{DefaultOperationId.class}).register(new Class[]{OperationType.class}).register(new Class[]{ReadConsistency.class}).register(new Class[]{ArrayList.class}).register(new Class[]{Collections.emptyList().getClass()}).register(new Class[]{HashSet.class}).register(new Class[]{DefaultRaftMember.class}).register(new Class[]{MemberId.class}).register(new Class[]{SessionId.class}).register(new Class[]{RaftMember.Type.class}).register(new Class[]{Instant.class}).register(new Class[]{Configuration.class}).build());
    private static final Namespace storageNamespace = Namespace.builder().register(new Class[]{CloseSessionEntry.class}).register(new Class[]{CommandEntry.class}).register(new Class[]{ConfigurationEntry.class}).register(new Class[]{InitializeEntry.class}).register(new Class[]{KeepAliveEntry.class}).register(new Class[]{MetadataEntry.class}).register(new Class[]{OpenSessionEntry.class}).register(new Class[]{QueryEntry.class}).register(new Class[]{PrimitiveOperation.class}).register(new Class[]{DefaultOperationId.class}).register(new Class[]{OperationType.class}).register(new Class[]{ReadConsistency.class}).register(new Class[]{ArrayList.class}).register(new Class[]{HashSet.class}).register(new Class[]{DefaultRaftMember.class}).register(new Class[]{MemberId.class}).register(new Class[]{RaftMember.Type.class}).register(new Class[]{Instant.class}).register(new Class[]{Configuration.class}).register(new Class[]{byte[].class}).register(new Class[]{long[].class}).build();
    private static final Serializer clientSerializer = Serializer.using((Namespace)Namespace.builder().register(new Class[]{ReadConsistency.class}).register(new Class[]{Maps.immutableEntry((Object)"", (Object)"").getClass()}).build());
    private int nextId;
    private int port = 5000;
    private List<Member> members = new ArrayList<Member>();
    private List<RaftClient> clients = new ArrayList<RaftClient>();
    private List<RaftServer> servers = new ArrayList<RaftServer>();
    private LocalRaftProtocolFactory protocolFactory;
    private List<ManagedMessagingService> messagingServices = new ArrayList<ManagedMessagingService>();
    private Map<MemberId, Address> addressMap = new ConcurrentHashMap<MemberId, Address>();
    private static final String[] KEYS = new String[1024];
    private final Random random = new Random();
    private final List<Long> iterations = new ArrayList<Long>();
    private final AtomicInteger totalOperations = new AtomicInteger();
    private final AtomicInteger writeCount = new AtomicInteger();
    private final AtomicInteger readCount = new AtomicInteger();
    private static final OperationId PUT;
    private static final OperationId GET;
    private static final OperationId REMOVE;
    private static final OperationId INDEX;

    public static void main(String[] args) {
        new RaftPerformanceTest().run();
    }

    @Override
    public void run() {
        for (int i = 0; i < 1; ++i) {
            try {
                this.iterations.add(this.runIteration());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        System.out.println("Completed 1 iterations");
        long averageRunTime = (long)this.iterations.stream().mapToLong(v -> v).average().getAsDouble();
        System.out.println(String.format("averageRunTime: %dms", averageRunTime));
        try {
            this.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long runIteration() throws Exception {
        this.reset();
        this.createServers(3);
        CompletableFuture[] futures = new CompletableFuture[5];
        RaftClient[] clients = new RaftClient[5];
        SessionClient[] proxies = new SessionClient[5];
        for (int i = 0; i < 5; ++i) {
            CompletableFuture future = new CompletableFuture();
            clients[i] = this.createClient();
            proxies[i] = (SessionClient)this.createProxy(clients[i]).connect().join();
            futures[i] = future;
        }
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < clients.length; ++i) {
            this.runProxy(proxies[i], futures[i]);
        }
        CompletableFuture.allOf(futures).join();
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        System.out.println(String.format("readCount: %d/%d, writeCount: %d/%d, runTime: %dms", this.readCount.get(), 1000000, this.writeCount.get(), 1000000, runTime));
        return runTime;
    }

    private void runProxy(SessionClient proxy, CompletableFuture<Void> future) {
        int count = this.totalOperations.incrementAndGet();
        if (count > 1000000) {
            future.complete(null);
        } else if (count % 10 < 10) {
            proxy.execute(PrimitiveOperation.operation((OperationId)PUT, (byte[])clientSerializer.encode((Object)Maps.immutableEntry((Object)this.randomKey(), (Object)UUID.randomUUID().toString())))).whenComplete((result, error) -> {
                if (error == null) {
                    this.writeCount.incrementAndGet();
                }
                this.runProxy(proxy, future);
            });
        } else {
            proxy.execute(PrimitiveOperation.operation((OperationId)GET, (byte[])clientSerializer.encode((Object)this.randomKey()))).whenComplete((result, error) -> {
                if (error == null) {
                    this.readCount.incrementAndGet();
                }
                this.runProxy(proxy, future);
            });
        }
    }

    private void reset() throws Exception {
        this.totalOperations.set(0);
        this.readCount.set(0);
        this.writeCount.set(0);
        this.shutdown();
        this.members = new ArrayList<Member>();
        this.clients = new ArrayList<RaftClient>();
        this.servers = new ArrayList<RaftServer>();
        this.messagingServices = new ArrayList<ManagedMessagingService>();
        this.addressMap = new ConcurrentHashMap<MemberId, Address>();
        this.protocolFactory = new LocalRaftProtocolFactory(protocolSerializer);
    }

    private void shutdown() throws Exception {
        this.clients.forEach(c -> {
            try {
                c.close().get(10L, TimeUnit.SECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.servers.forEach(s -> {
            try {
                if (s.isRunning()) {
                    s.shutdown().get(10L, TimeUnit.SECONDS);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.messagingServices.forEach(m -> {
            try {
                m.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Path directory = Paths.get("target/perf-logs/", new String[0]);
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private String randomKey() {
        return KEYS[this.randomNumber(KEYS.length)];
    }

    private int randomNumber(int limit) {
        return this.random.nextInt(limit);
    }

    private Member nextNode() {
        Address address = Address.from((String)"localhost", (int)(++this.port));
        Member member = Member.builder((MemberId)MemberId.from((String)String.valueOf(++this.nextId))).withAddress(address).build();
        this.addressMap.put(member.id(), address);
        return member;
    }

    private List<RaftServer> createServers(int nodes) throws Exception {
        ArrayList<RaftServer> servers = new ArrayList<RaftServer>();
        for (int i = 0; i < nodes; ++i) {
            this.members.add(this.nextNode());
        }
        CountDownLatch latch = new CountDownLatch(nodes);
        for (int i = 0; i < nodes; ++i) {
            RaftServer server = this.createServer(this.members.get(i), Lists.newArrayList(this.members));
            server.bootstrap((Collection)this.members.stream().map(Member::id).collect(Collectors.toList())).thenRun(latch::countDown);
            servers.add(server);
        }
        latch.await(30000L, TimeUnit.MILLISECONDS);
        return servers;
    }

    private RaftServer createServer(Member member, List<Node> members) {
        final ManagedMessagingService messagingService = (ManagedMessagingService)new NettyMessagingService("test", member.address(), new MessagingConfig()).start().join();
        this.messagingServices.add(messagingService);
        RaftServerMessagingProtocol protocol = new RaftServerMessagingProtocol((MessagingService)messagingService, protocolSerializer, this.addressMap::get);
        BootstrapService bootstrapService = new BootstrapService(){

            public MessagingService getMessagingService() {
                return messagingService;
            }

            public UnicastService getUnicastService() {
                return new UnicastServiceAdapter();
            }

            public BroadcastService getBroadcastService() {
                return new BroadcastServiceAdapter();
            }
        };
        RaftServer.Builder builder = RaftServer.builder((MemberId)member.id()).withProtocol((RaftServerProtocol)protocol).withThreadModel(ThreadModel.SHARED_THREAD_POOL).withMembershipService((ClusterMembershipService)new DefaultClusterMembershipService(member, Version.from((String)"1.0.0"), (ManagedNodeDiscoveryService)new DefaultNodeDiscoveryService(bootstrapService, (Node)member, (NodeDiscoveryProvider)new BootstrapDiscoveryProvider(members)), bootstrapService, (GroupMembershipProtocol)new HeartbeatMembershipProtocol(new HeartbeatMembershipProtocolConfig()))).withStorage(RaftStorage.builder().withStorageLevel(StorageLevel.DISK).withDirectory(new File(String.format("target/perf-logs/%s", member.id()))).withNamespace(storageNamespace).withMaxSegmentSize(0x4000000).withDynamicCompaction().withFlushOnCommit(false).build());
        RaftServer server = (RaftServer)builder.build();
        this.servers.add(server);
        return server;
    }

    private RaftClient createClient() throws Exception {
        Member member = this.nextNode();
        MessagingService messagingService = (MessagingService)new NettyMessagingService("test", member.address(), new MessagingConfig()).start().join();
        RaftClientMessagingProtocol protocol = new RaftClientMessagingProtocol(messagingService, protocolSerializer, this.addressMap::get);
        RaftClient client = (RaftClient)RaftClient.builder().withMemberId(member.id()).withPartitionId(PartitionId.from((String)"test", (int)1)).withProtocol((RaftClientProtocol)protocol).withThreadModel(ThreadModel.SHARED_THREAD_POOL).build();
        client.connect((Collection)this.members.stream().map(Member::id).collect(Collectors.toList())).join();
        this.clients.add(client);
        return client;
    }

    private SessionClient createProxy(RaftClient client) {
        return (SessionClient)client.sessionBuilder("raft-performance-test", (PrimitiveType)TestPrimitiveType.INSTANCE, new ServiceConfig()).withReadConsistency(READ_CONSISTENCY).withCommunicationStrategy(COMMUNICATION_STRATEGY).build();
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            RaftPerformanceTest.KEYS[i] = UUID.randomUUID().toString();
        }
        PUT = OperationId.command((String)"put");
        GET = OperationId.query((String)"get");
        REMOVE = OperationId.command((String)"remove");
        INDEX = OperationId.command((String)"index");
    }

    private static class BroadcastServiceAdapter
    implements BroadcastService {
        private BroadcastServiceAdapter() {
        }

        public void broadcast(String subject, byte[] message) {
        }

        public void addListener(String subject, Consumer<byte[]> listener) {
        }

        public void removeListener(String subject, Consumer<byte[]> listener) {
        }
    }

    private static class UnicastServiceAdapter
    implements UnicastService {
        private UnicastServiceAdapter() {
        }

        public void unicast(Address address, String subject, byte[] message) {
        }

        public void addListener(String subject, BiConsumer<Address, byte[]> listener, Executor executor) {
        }

        public void removeListener(String subject, BiConsumer<Address, byte[]> listener) {
        }
    }

    public static class TestMember
    implements RaftMember {
        private final MemberId memberId;
        private final RaftMember.Type type;

        public TestMember(MemberId memberId, RaftMember.Type type) {
            this.memberId = memberId;
            this.type = type;
        }

        public MemberId memberId() {
            return this.memberId;
        }

        public int hash() {
            return this.memberId.hashCode();
        }

        public RaftMember.Type getType() {
            return this.type;
        }

        public void addTypeChangeListener(Consumer<RaftMember.Type> listener) {
        }

        public void removeTypeChangeListener(Consumer<RaftMember.Type> listener) {
        }

        public Instant getLastUpdated() {
            return Instant.now();
        }

        public CompletableFuture<Void> promote() {
            return null;
        }

        public CompletableFuture<Void> promote(RaftMember.Type type) {
            return null;
        }

        public CompletableFuture<Void> demote() {
            return null;
        }

        public CompletableFuture<Void> demote(RaftMember.Type type) {
            return null;
        }

        public CompletableFuture<Void> remove() {
            return null;
        }
    }

    public static class PerformanceService
    extends AbstractPrimitiveService {
        private Map<String, String> map = new HashMap<String, String>();

        public PerformanceService() {
            super((PrimitiveType)TestPrimitiveType.INSTANCE);
        }

        public Serializer serializer() {
            return clientSerializer;
        }

        protected void configure(ServiceExecutor executor) {
            executor.register(PUT, this::put);
            executor.register(GET, this::get);
            executor.register(REMOVE, this::remove);
            executor.register(INDEX, this::index);
        }

        public void backup(BackupOutput writer) {
            writer.writeInt(this.map.size());
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                writer.writeString(entry.getKey());
                writer.writeString(entry.getValue());
            }
        }

        public void restore(BackupInput reader) {
            this.map = new HashMap<String, String>();
            int size = reader.readInt();
            for (int i = 0; i < size; ++i) {
                String key = reader.readString();
                String value = reader.readString();
                this.map.put(key, value);
            }
        }

        protected long put(Commit<Map.Entry<String, String>> commit) {
            this.map.put((String)((Map.Entry)commit.value()).getKey(), (String)((Map.Entry)commit.value()).getValue());
            return commit.index();
        }

        protected String get(Commit<String> commit) {
            return this.map.get(commit.value());
        }

        protected long remove(Commit<String> commit) {
            this.map.remove(commit.value());
            return commit.index();
        }

        protected long index(Commit<Void> commit) {
            return commit.index();
        }
    }

    public static class TestPrimitiveType
    implements PrimitiveType {
        private static final TestPrimitiveType INSTANCE = new TestPrimitiveType();

        public String name() {
            return "raft-performance-test";
        }

        public PrimitiveConfig newConfig() {
            throw new UnsupportedOperationException();
        }

        public PrimitiveBuilder newBuilder(String primitiveName, PrimitiveConfig config, PrimitiveManagementService managementService) {
            throw new UnsupportedOperationException();
        }

        public PrimitiveService newService(ServiceConfig config) {
            return new PerformanceService();
        }
    }
}

