/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.cluster.NodeId;
import io.atomix.messaging.MessagingService;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.net.Address;
import io.atomix.utils.serializer.Serializer;
import java.net.ConnectException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class RaftMessagingProtocol {
    protected final MessagingService messagingService;
    protected final Serializer serializer;
    private final Function<NodeId, Address> addressProvider;

    public RaftMessagingProtocol(MessagingService messagingService, Serializer serializer, Function<NodeId, Address> addressProvider) {
        this.messagingService = messagingService;
        this.serializer = serializer;
        this.addressProvider = addressProvider;
    }

    protected Address address(NodeId nodeId) {
        return this.addressProvider.apply(nodeId);
    }

    protected <T, U> CompletableFuture<U> sendAndReceive(NodeId nodeId, String type, T request) {
        Address address = this.address(nodeId);
        if (address == null) {
            return Futures.exceptionalFuture((Throwable)new ConnectException());
        }
        return this.messagingService.sendAndReceive(address, type, this.serializer.encode(request)).thenApply(arg_0 -> ((Serializer)this.serializer).decode(arg_0));
    }

    protected CompletableFuture<Void> sendAsync(NodeId nodeId, String type, Object request) {
        Address address = this.address(nodeId);
        if (address != null) {
            return this.messagingService.sendAsync(this.address(nodeId), type, this.serializer.encode(request));
        }
        return CompletableFuture.completedFuture(null);
    }

    protected <T, U> void registerHandler(String type, Function<T, CompletableFuture<U>> handler) {
        this.messagingService.registerHandler(type, (e, p) -> {
            CompletableFuture future = new CompletableFuture();
            ((CompletableFuture)handler.apply(this.serializer.decode(p))).whenComplete((result, error) -> {
                if (error == null) {
                    future.complete(this.serializer.encode(result));
                } else {
                    future.completeExceptionally((Throwable)error);
                }
            });
            return future;
        });
    }

    protected void unregisterHandler(String type) {
        this.messagingService.unregisterHandler(type);
    }
}

