/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.messaging.Endpoint;
import io.atomix.messaging.MessagingService;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.serializer.Serializer;
import io.atomix.utils.concurrent.Futures;
import java.net.ConnectException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class RaftMessagingProtocol {
    protected final MessagingService messagingService;
    protected final Serializer serializer;
    private final Function<MemberId, Endpoint> endpointProvider;

    public RaftMessagingProtocol(MessagingService messagingService, Serializer serializer, Function<MemberId, Endpoint> endpointProvider) {
        this.messagingService = messagingService;
        this.serializer = serializer;
        this.endpointProvider = endpointProvider;
    }

    protected Endpoint endpoint(MemberId memberId) {
        return this.endpointProvider.apply(memberId);
    }

    protected <T, U> CompletableFuture<U> sendAndReceive(MemberId memberId, String type, T request) {
        Endpoint endpoint = this.endpoint(memberId);
        if (endpoint == null) {
            return Futures.exceptionalFuture((Throwable)new ConnectException());
        }
        return this.messagingService.sendAndReceive(endpoint, type, this.serializer.encode(request)).thenApply(arg_0 -> ((Serializer)this.serializer).decode(arg_0));
    }

    protected CompletableFuture<Void> sendAsync(MemberId memberId, String type, Object request) {
        Endpoint endpoint = this.endpoint(memberId);
        if (endpoint != null) {
            return this.messagingService.sendAsync(this.endpoint(memberId), type, this.serializer.encode(request));
        }
        return CompletableFuture.completedFuture(null);
    }

    protected <T, U> void registerHandler(String type, Function<T, CompletableFuture<U>> handler) {
        this.messagingService.registerHandler(type, (e, p) -> {
            CompletableFuture future = new CompletableFuture();
            ((CompletableFuture)handler.apply(this.serializer.decode(p))).whenComplete((result, error) -> {
                if (error == null) {
                    future.complete(this.serializer.encode(result));
                } else {
                    future.completeExceptionally((Throwable)error);
                }
            });
            return future;
        });
    }

    protected void unregisterHandler(String type) {
        this.messagingService.unregisterHandler(type);
    }
}

