/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.esotericsoftware.kryo.KryoException;
import io.atomix.storage.StorageException;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.utils.serializer.Namespace;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;

class FileChannelJournalSegmentWriter<E>
implements JournalWriter<E> {
    private final FileChannel channel;
    private final JournalSegment segment;
    private final int maxEntrySize;
    private final JournalIndex index;
    private final Namespace namespace;
    private final ByteBuffer memory;
    private final long firstIndex;
    private Indexed<E> lastEntry;

    FileChannelJournalSegmentWriter(FileChannel channel, JournalSegment segment, int maxEntrySize, JournalIndex index, Namespace namespace) {
        this.channel = channel;
        this.segment = segment;
        this.maxEntrySize = maxEntrySize;
        this.index = index;
        this.memory = ByteBuffer.allocate((maxEntrySize + 4 + 4) * 2);
        this.memory.limit(0);
        this.namespace = namespace;
        this.firstIndex = segment.index();
        this.reset(0L);
    }

    @Override
    public void reset(long index) {
        long nextIndex = this.firstIndex;
        try {
            this.channel.position(64L);
            this.memory.clear().flip();
            long position = this.channel.position();
            if (this.memory.remaining() < this.maxEntrySize) {
                this.memory.clear();
                this.channel.read(this.memory);
                this.channel.position(position);
                this.memory.flip();
            }
            this.memory.mark();
            int length = this.memory.getInt();
            while (0 < length && length <= this.maxEntrySize && (index == 0L || nextIndex <= index)) {
                long checksum = (long)this.memory.getInt() & 0xFFFFFFFFL;
                CRC32 crc32 = new CRC32();
                crc32.update(this.memory.array(), this.memory.position(), length);
                if (checksum != crc32.getValue()) break;
                int limit = this.memory.limit();
                this.memory.limit(this.memory.position() + length);
                Object entry = this.namespace.deserialize(this.memory);
                this.memory.limit(limit);
                this.lastEntry = new Indexed<Object>(nextIndex, entry, length);
                this.index.index(nextIndex, (int)position);
                ++nextIndex;
                position = this.channel.position() + (long)this.memory.position();
                if (this.memory.remaining() < this.maxEntrySize) {
                    this.channel.position(position);
                    this.memory.clear();
                    this.channel.read(this.memory);
                    this.channel.position(position);
                    this.memory.flip();
                }
                this.memory.mark();
                length = this.memory.getInt();
            }
            this.channel.position(this.channel.position() + (long)this.memory.reset().position());
        }
        catch (BufferUnderflowException e) {
            try {
                this.channel.position(this.channel.position() + (long)this.memory.reset().position());
            }
            catch (IOException e2) {
                throw new StorageException(e2);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public long getLastIndex() {
        return this.lastEntry != null ? this.lastEntry.index() : this.segment.index() - 1L;
    }

    @Override
    public Indexed<E> getLastEntry() {
        return this.lastEntry;
    }

    @Override
    public long getNextIndex() {
        if (this.lastEntry != null) {
            return this.lastEntry.index() + 1L;
        }
        return this.firstIndex;
    }

    public long size() {
        try {
            return this.channel.position();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public boolean isEmpty() {
        return this.lastEntry == null;
    }

    public boolean isFull() {
        return this.size() >= (long)this.segment.descriptor().maxSegmentSize() || this.getNextIndex() - this.firstIndex >= (long)this.segment.descriptor().maxEntries();
    }

    public long firstIndex() {
        return this.firstIndex;
    }

    @Override
    public void append(Indexed<E> entry) {
        long nextIndex = this.getNextIndex();
        if (entry.index() > nextIndex) {
            throw new IndexOutOfBoundsException("Entry index is not sequential");
        }
        if (entry.index() < nextIndex) {
            this.truncate(entry.index() - 1L);
        }
        this.append(entry.entry());
    }

    @Override
    public <T extends E> Indexed<T> append(T entry) {
        long index = this.getNextIndex();
        try {
            this.memory.clear();
            this.memory.position(8);
            try {
                this.namespace.serialize(entry, this.memory);
            }
            catch (KryoException e) {
                throw new StorageException.TooLarge("Entry size exceeds maximum allowed bytes (" + this.maxEntrySize + ")");
            }
            this.memory.flip();
            int length = this.memory.limit() - 8;
            long position = this.channel.position();
            if ((long)this.segment.descriptor().maxSegmentSize() - position < (long)(length + 4 + 4)) {
                throw new BufferOverflowException();
            }
            if (length > this.maxEntrySize) {
                throw new StorageException.TooLarge("Entry size " + length + " exceeds maximum allowed bytes (" + this.maxEntrySize + ")");
            }
            CRC32 crc32 = new CRC32();
            crc32.update(this.memory.array(), 8, this.memory.limit() - 8);
            long checksum = crc32.getValue();
            this.memory.putInt(0, length);
            this.memory.putInt(4, (int)checksum);
            this.channel.write(this.memory);
            Indexed<T> indexedEntry = new Indexed<T>(index, entry, length);
            this.lastEntry = indexedEntry;
            this.index.index(index, (int)position);
            return indexedEntry;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void commit(long index) {
    }

    @Override
    public void truncate(long index) {
        if (index >= this.getLastIndex()) {
            return;
        }
        this.lastEntry = null;
        try {
            this.index.truncate(index);
            if (index < this.segment.index()) {
                this.channel.position(64L);
                this.channel.write(this.zero());
                this.channel.position(64L);
            } else {
                this.reset(index);
                long position = this.channel.position();
                this.channel.write(this.zero());
                this.channel.position(position);
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    private ByteBuffer zero() {
        this.memory.clear();
        for (int i = 0; i < this.memory.limit(); ++i) {
            this.memory.put(i, (byte)0);
        }
        return this.memory;
    }

    @Override
    public void flush() {
        try {
            this.channel.force(true);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void close() {
        this.flush();
    }
}

