/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.StorageException;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.Position;
import io.atomix.utils.serializer.Namespace;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import java.util.zip.CRC32;

class FileChannelJournalSegmentReader<E>
implements JournalReader<E> {
    private final FileChannel channel;
    private final int maxEntrySize;
    private final JournalIndex index;
    private final Namespace namespace;
    private final ByteBuffer memory;
    private final long firstIndex;
    private Indexed<E> currentEntry;
    private Indexed<E> nextEntry;

    FileChannelJournalSegmentReader(FileChannel channel, JournalSegment<E> segment, int maxEntrySize, JournalIndex index, Namespace namespace) {
        this.channel = channel;
        this.maxEntrySize = maxEntrySize;
        this.index = index;
        this.namespace = namespace;
        this.memory = ByteBuffer.allocate((maxEntrySize + 4 + 4) * 2);
        this.firstIndex = segment.index();
        this.reset();
    }

    @Override
    public long getFirstIndex() {
        return this.firstIndex;
    }

    @Override
    public long getCurrentIndex() {
        return this.currentEntry != null ? this.currentEntry.index() : 0L;
    }

    @Override
    public Indexed<E> getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public long getNextIndex() {
        return this.currentEntry != null ? this.currentEntry.index() + 1L : this.firstIndex;
    }

    @Override
    public void reset(long index) {
        this.reset();
        Position position = this.index.lookup(index - 1L);
        if (position != null) {
            this.currentEntry = new Indexed<Object>(position.index() - 1L, null, 0);
            try {
                this.channel.position(position.position());
                this.memory.clear().flip();
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
            this.readNext();
        }
        while (this.getNextIndex() < index && this.hasNext()) {
            this.next();
        }
    }

    @Override
    public void reset() {
        try {
            this.channel.position(64L);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        this.memory.clear().limit(0);
        this.currentEntry = null;
        this.nextEntry = null;
        this.readNext();
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry == null) {
            this.readNext();
        }
        return this.nextEntry != null;
    }

    @Override
    public Indexed<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEntry = this.nextEntry;
        this.nextEntry = null;
        this.readNext();
        return this.currentEntry;
    }

    private void readNext() {
        block7: {
            long index = this.getNextIndex();
            try {
                if (this.memory.remaining() < this.maxEntrySize) {
                    long position = this.channel.position() + (long)this.memory.position();
                    this.channel.position(position);
                    this.memory.clear();
                    this.channel.read(this.memory);
                    this.channel.position(position);
                    this.memory.flip();
                }
                this.memory.mark();
                try {
                    int length = this.memory.getInt();
                    if (length <= 0 || length > this.maxEntrySize) {
                        this.memory.reset().limit(this.memory.position());
                        this.nextEntry = null;
                        return;
                    }
                    long checksum = (long)this.memory.getInt() & 0xFFFFFFFFL;
                    CRC32 crc32 = new CRC32();
                    crc32.update(this.memory.array(), this.memory.position(), length);
                    if (checksum == crc32.getValue()) {
                        int limit = this.memory.limit();
                        this.memory.limit(this.memory.position() + length);
                        Object entry = this.namespace.deserialize(this.memory);
                        this.memory.limit(limit);
                        this.nextEntry = new Indexed<Object>(index, entry, length);
                        break block7;
                    }
                    this.memory.reset().limit(this.memory.position());
                    this.nextEntry = null;
                }
                catch (BufferUnderflowException e) {
                    this.memory.reset().limit(this.memory.position());
                    this.nextEntry = null;
                }
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
    }

    @Override
    public void close() {
    }
}

