/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.HeapBuffer;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalSegmentCache;
import io.atomix.storage.journal.JournalSegmentDescriptor;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.Position;
import io.atomix.utils.serializer.Serializer;
import java.nio.BufferUnderflowException;
import java.util.NoSuchElementException;
import java.util.zip.CRC32;

public class JournalSegmentReader<E>
implements JournalReader<E> {
    private final Buffer buffer;
    private final int maxEntrySize;
    private final JournalSegmentCache cache;
    private final JournalIndex index;
    private final Serializer serializer;
    private final Buffer memory = HeapBuffer.allocate().flip();
    private final long firstIndex;
    private Indexed<E> currentEntry;
    private Indexed<E> nextEntry;

    public JournalSegmentReader(JournalSegmentDescriptor descriptor, int maxEntrySize, JournalSegmentCache cache, JournalIndex index, Serializer serializer) {
        this.buffer = descriptor.buffer().slice().duplicate();
        this.maxEntrySize = maxEntrySize;
        this.cache = cache;
        this.index = index;
        this.serializer = serializer;
        this.firstIndex = descriptor.index();
        this.readNext();
    }

    @Override
    public long getCurrentIndex() {
        return this.currentEntry != null ? this.currentEntry.index() : 0L;
    }

    @Override
    public Indexed<E> getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public long getNextIndex() {
        return this.currentEntry != null ? this.currentEntry.index() + 1L : this.firstIndex;
    }

    @Override
    public void reset(long index) {
        this.reset();
        Position position = this.index.lookup(index - 1L);
        if (position != null) {
            this.currentEntry = new Indexed<Object>(position.index() - 1L, null, 0);
            this.buffer.position(position.position());
            this.memory.clear().flip();
            this.readNext();
        }
        while (this.getNextIndex() < index && this.hasNext()) {
            this.next();
        }
    }

    @Override
    public void reset() {
        this.buffer.clear();
        this.memory.clear().flip();
        this.currentEntry = null;
        this.nextEntry = null;
        this.readNext();
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry == null) {
            this.readNext();
        }
        return this.nextEntry != null;
    }

    @Override
    public Indexed<E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEntry = this.nextEntry;
        this.nextEntry = null;
        this.readNext();
        return this.currentEntry;
    }

    private void readNext() {
        long index = this.getNextIndex();
        Indexed cachedEntry = this.cache.get(index);
        if (cachedEntry != null) {
            this.nextEntry = cachedEntry;
            this.buffer.skip(this.memory.position() + cachedEntry.size() + 4 + 4);
            this.memory.clear().limit(0);
            return;
        }
        if (this.cache.index() > 0L && this.cache.index() < index) {
            this.nextEntry = null;
            return;
        }
        if (this.memory.remaining() < this.maxEntrySize) {
            this.buffer.skip(this.memory.position()).mark().read(this.memory.clear().limit(this.maxEntrySize * 2)).reset();
            this.memory.flip();
        }
        this.memory.mark();
        try {
            int length = this.memory.readInt();
            if (length <= 0 || length > this.maxEntrySize) {
                this.memory.reset().limit(this.memory.position());
                this.nextEntry = null;
                return;
            }
            long checksum = this.memory.readUnsignedInt();
            byte[] bytes = new byte[length];
            this.memory.read(bytes);
            CRC32 crc32 = new CRC32();
            crc32.update(bytes, 0, length);
            if (checksum == crc32.getValue()) {
                Object entry = this.serializer.decode(bytes);
                this.nextEntry = new Indexed<Object>(index, entry, length);
            } else {
                this.memory.reset().limit(this.memory.position());
                this.nextEntry = null;
            }
        }
        catch (BufferUnderflowException e) {
            this.memory.reset().limit(this.memory.position());
            this.nextEntry = null;
        }
    }

    @Override
    public void close() {
        this.memory.close();
        this.buffer.close();
    }
}

