/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalSegmentWriter;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.SegmentedJournal;
import java.nio.BufferOverflowException;

public class SegmentedJournalWriter<E>
implements JournalWriter<E> {
    private final SegmentedJournal<E> journal;
    private JournalSegment<E> currentSegment;
    private JournalSegmentWriter<E> currentWriter;

    public SegmentedJournalWriter(SegmentedJournal<E> journal) {
        this.journal = journal;
        this.currentSegment = journal.getLastSegment();
        this.currentWriter = this.currentSegment.writer();
    }

    @Override
    public long getLastIndex() {
        return this.currentWriter.getLastIndex();
    }

    @Override
    public Indexed<E> getLastEntry() {
        return this.currentWriter.getLastEntry();
    }

    @Override
    public long getNextIndex() {
        return this.currentWriter.getNextIndex();
    }

    public void reset(long index) {
        this.currentWriter.close();
        this.currentSegment = this.journal.resetSegments(index);
        this.currentWriter = this.currentSegment.writer();
        this.journal.resetHead(index);
    }

    @Override
    public <T extends E> Indexed<T> append(T entry) {
        try {
            if (this.currentWriter.isFull()) {
                this.currentWriter.flush();
                this.currentSegment = this.journal.getNextSegment();
                this.currentWriter = this.currentSegment.writer();
            }
            return this.currentWriter.append(entry);
        }
        catch (BufferOverflowException e) {
            if (this.currentWriter.firstIndex() == this.currentWriter.getNextIndex()) {
                throw e;
            }
            this.currentWriter.flush();
            this.currentSegment = this.journal.getNextSegment();
            this.currentWriter = this.currentSegment.writer();
            return this.currentWriter.append(entry);
        }
    }

    @Override
    public void append(Indexed<E> entry) {
        try {
            if (this.currentWriter.isFull()) {
                this.currentWriter.flush();
                this.currentSegment = this.journal.getNextSegment();
                this.currentWriter = this.currentSegment.writer();
            }
            this.currentWriter.append(entry);
        }
        catch (BufferOverflowException e) {
            if (this.currentWriter.firstIndex() == this.currentWriter.getNextIndex()) {
                throw e;
            }
            this.currentWriter.flush();
            this.currentSegment = this.journal.getNextSegment();
            this.currentWriter = this.currentSegment.writer();
            this.currentWriter.append(entry);
        }
    }

    @Override
    public void truncate(long index) {
        while (index < this.currentWriter.firstIndex() - 1L) {
            this.currentWriter.close();
            this.journal.removeSegment(this.currentSegment);
            this.currentSegment = this.journal.getLastSegment();
            this.currentWriter = this.currentSegment.writer();
        }
        this.currentWriter.truncate(index);
        this.journal.resetTail(index + 1L);
    }

    @Override
    public void flush() {
        this.currentWriter.flush();
    }

    @Override
    public void close() {
        this.currentWriter.close();
    }
}

