/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.Bytes;
import io.atomix.storage.buffer.SwappedBytes;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class AbstractBytes
implements Bytes {
    private boolean open = true;
    private SwappedBytes swap;

    protected void checkOpen() {
        if (!this.open) {
            throw new IllegalStateException("bytes not open");
        }
    }

    protected void checkOffset(int offset) {
        this.checkOpen();
        if (offset < 0 || offset > this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected int checkRead(int offset, int length) {
        this.checkOffset(offset);
        int position = offset + length;
        if (position > this.size()) {
            throw new BufferUnderflowException();
        }
        return position;
    }

    protected int checkWrite(int offset, int length) {
        this.checkOffset(offset);
        int position = offset + length;
        if (position > this.size()) {
            throw new BufferOverflowException();
        }
        return position;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public Bytes order(ByteOrder order) {
        if (order == null) {
            throw new NullPointerException("order cannot be null");
        }
        if (order == this.order()) {
            return this;
        }
        if (this.swap != null) {
            return this.swap;
        }
        this.swap = new SwappedBytes(this);
        return this.swap;
    }

    @Override
    public boolean readBoolean(int offset) {
        return this.readByte(offset) == 1;
    }

    @Override
    public int readUnsignedByte(int offset) {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public int readUnsignedShort(int offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    @Override
    public int readMedium(int offset) {
        return this.readByte(offset) << 16 | (this.readByte(offset + 1) & 0xFF) << 8 | this.readByte(offset + 2) & 0xFF;
    }

    @Override
    public int readUnsignedMedium(int offset) {
        return (this.readByte(offset) & 0xFF) << 16 | (this.readByte(offset + 1) & 0xFF) << 8 | this.readByte(offset + 2) & 0xFF;
    }

    @Override
    public long readUnsignedInt(int offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public String readString(int offset) {
        return this.readString(offset, Charset.defaultCharset());
    }

    @Override
    public String readString(int offset, Charset charset) {
        if (this.readBoolean(offset)) {
            byte[] bytes = new byte[this.readUnsignedShort(offset + 1)];
            this.read(offset + 1 + 2, bytes, 0, bytes.length);
            return new String(bytes, charset);
        }
        return null;
    }

    @Override
    public String readUTF8(int offset) {
        return this.readString(offset, StandardCharsets.UTF_8);
    }

    @Override
    public Bytes writeBoolean(int offset, boolean b) {
        return (Bytes)this.writeByte(offset, b ? 1 : 0);
    }

    @Override
    public Bytes writeUnsignedByte(int offset, int b) {
        return (Bytes)this.writeByte(offset, (byte)b);
    }

    @Override
    public Bytes writeUnsignedShort(int offset, int s) {
        return (Bytes)this.writeShort(offset, (short)s);
    }

    @Override
    public Bytes writeMedium(int offset, int m) {
        this.writeByte(offset, (byte)(m >>> 16));
        this.writeByte(offset + 1, (byte)(m >>> 8));
        this.writeByte(offset + 2, (byte)m);
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(int offset, int m) {
        return this.writeMedium(offset, m);
    }

    @Override
    public Bytes writeUnsignedInt(int offset, long i) {
        return (Bytes)this.writeInt(offset, (int)i);
    }

    @Override
    public Bytes writeString(int offset, String s) {
        return this.writeString(offset, s, Charset.defaultCharset());
    }

    @Override
    public Bytes writeString(int offset, String s, Charset charset) {
        if (s == null) {
            return this.writeBoolean(offset, Boolean.FALSE);
        }
        this.writeBoolean(offset, Boolean.TRUE);
        byte[] bytes = s.getBytes(charset);
        return (Bytes)this.writeUnsignedShort(offset + 1, bytes.length).write(offset + 1 + 2, bytes, 0, bytes.length);
    }

    @Override
    public Bytes writeUTF8(int offset, String s) {
        return this.writeString(offset, s, StandardCharsets.UTF_8);
    }

    @Override
    public Bytes flush() {
        return this;
    }

    @Override
    public void close() {
        this.open = false;
    }
}

