/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.queue.AsyncDistributedQueue;
import io.atomix.core.queue.DistributedQueueConfig;
import io.atomix.core.queue.DistributedQueueType;
import io.atomix.primitive.PrimitiveType;
import io.atomix.rest.AtomixResource;
import io.atomix.rest.resources.DistributedCollectionResource;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtomixResource
@Path(value="/queue")
public class DistributedQueueResource
extends DistributedCollectionResource<AsyncDistributedQueue<String>, DistributedQueueConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedQueueResource.class);

    public DistributedQueueResource() {
        super((PrimitiveType)DistributedQueueType.instance());
    }

    @POST
    @Path(value="/{name}/remove")
    @Produces(value={"application/json"})
    public void remove(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(queue -> queue.remove())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{name}/poll")
    @Produces(value={"application/json"})
    public void poll(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(queue -> queue.poll())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{name}/element")
    @Produces(value={"application/json"})
    public void element(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(queue -> queue.element())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{name}/peek")
    @Produces(value={"application/json"})
    public void peek(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(queue -> queue.peek())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

