/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.election.AsyncLeaderElection;
import io.atomix.core.election.LeaderElectionConfig;
import io.atomix.core.election.LeaderElectionType;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.LeadershipEvent;
import io.atomix.core.election.LeadershipEventListener;
import io.atomix.primitive.PrimitiveType;
import io.atomix.rest.AtomixResource;
import io.atomix.rest.impl.EventLog;
import io.atomix.rest.impl.EventManager;
import io.atomix.rest.resources.PrimitiveResource;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtomixResource
@Path(value="/leader-election")
public class LeaderElectionResource
extends PrimitiveResource<AsyncLeaderElection<String>, LeaderElectionConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderElectionResource.class);

    public LeaderElectionResource() {
        super((PrimitiveType)LeaderElectionType.instance());
    }

    private String getEventLogName(String name, String id) {
        return String.format("%s-%s", name, id);
    }

    @POST
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    public void run(@PathParam(value="name") String name, @Context EventManager events, @Suspended AsyncResponse response) {
        String id = UUID.randomUUID().toString();
        EventLog eventLog = events.getOrCreateEventLog(AsyncLeaderElection.class, this.getEventLogName(name, id), l -> e -> l.addEvent(e));
        this.getPrimitive(name).thenAccept(election -> election.addListener((LeadershipEventListener)eventLog.listener()).whenComplete((listenResult, listenError) -> {
            if (listenError == null) {
                election.run((Object)id).whenComplete((runResult, runError) -> {
                    if (runError == null) {
                        response.resume((Object)Response.ok((Object)id).build());
                    } else {
                        LOGGER.warn("{}", runError);
                        response.resume((Object)Response.serverError().build());
                    }
                });
            } else {
                LOGGER.warn("{}", listenError);
                response.resume((Object)Response.serverError().build());
            }
        }));
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    public void getLeadership(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(election -> election.getLeadership())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new LeadershipResponse((Leadership<String>)result)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{name}/{id}")
    public void listen(@PathParam(value="name") String name, @PathParam(value="id") String id, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog<LeadershipEventListener<String>, LeadershipEvent<String>> eventLog = events.getEventLog(AsyncLeaderElection.class, this.getEventLogName(name, id));
        this.consumeNextEvent(eventLog, name, id, response);
    }

    private void consumeNextEvent(EventLog<LeadershipEventListener<String>, LeadershipEvent<String>> eventLog, String name, String id, AsyncResponse response) {
        eventLog.nextEvent().whenComplete((event, error) -> {
            if (error == null) {
                if (event.newLeadership().leader() != null && ((String)event.newLeadership().leader().id()).equals(id)) {
                    response.resume((Object)Response.ok((Object)new LeadershipResponse((Leadership<String>)event.newLeadership())).build());
                } else if (event.newLeadership().candidates().stream().noneMatch(c -> c.equals(id))) {
                    ((CompletableFuture)this.getPrimitive(name).thenCompose(election -> election.removeListener((LeadershipEventListener)eventLog.listener()))).whenComplete((removeResult, removeError) -> response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build()));
                }
            } else {
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            }
        });
    }

    @DELETE
    @Path(value="/{name}/{id}")
    public void withdraw(@PathParam(value="name") String name, @PathParam(value="id") String id, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.removeEventLog(AsyncLeaderElection.class, this.getEventLogName(name, id));
        if (eventLog != null && eventLog.close()) {
            this.getPrimitive(name).thenAccept(election -> election.removeListener((LeadershipEventListener)eventLog.listener()).whenComplete((removeResult, removeError) -> election.withdraw((Object)id).whenComplete((withdrawResult, withdrawError) -> {
                if (withdrawError == null) {
                    response.resume((Object)Response.ok().build());
                } else {
                    LOGGER.warn("{}", removeError);
                    response.resume((Object)Response.serverError().build());
                }
            })));
        } else {
            response.resume((Object)Response.ok().build());
        }
    }

    @POST
    @Path(value="/{name}/{id}/anoint")
    public void anoint(@PathParam(value="name") String name, @PathParam(value="id") String id, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(election -> election.anoint((Object)id))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{name}/{id}/promote")
    public void promote(@PathParam(value="name") String name, @PathParam(value="id") String id, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(election -> election.promote((Object)id))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{name}/{id}/evict")
    public void evict(@PathParam(value="name") String name, @PathParam(value="id") String id, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(election -> election.evict((Object)id))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    static class LeadershipResponse {
        private final Leadership<String> leadership;

        public LeadershipResponse(Leadership<String> leadership) {
            this.leadership = leadership;
        }

        public String getLeader() {
            return this.leadership.leader() != null ? (String)this.leadership.leader().id() : null;
        }

        public List<String> getCandidates() {
            return this.leadership.candidates();
        }
    }
}

