/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import com.google.common.collect.Sets;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMapConfig;
import io.atomix.core.map.AtomicMapType;
import io.atomix.primitive.PrimitiveType;
import io.atomix.rest.AtomixResource;
import io.atomix.rest.resources.PrimitiveResource;
import io.atomix.utils.time.Versioned;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtomixResource
@Path(value="/atomic-map")
public class AtomicMapResource
extends PrimitiveResource<AsyncAtomicMap<String, String>, AtomicMapConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicMapResource.class);

    public AtomicMapResource() {
        super((PrimitiveType)AtomicMapType.instance());
    }

    @GET
    @Path(value="/{name}/{key}")
    @Produces(value={"application/json"})
    public void get(@PathParam(value="name") String name, @PathParam(value="key") String key, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(map -> map.get((Object)key))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)(result != null ? new VersionedResult((Versioned<String>)result) : null)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @PUT
    @Path(value="/{name}/{key}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public void put(@PathParam(value="name") String name, @PathParam(value="key") String key, String value, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(map -> map.put((Object)key, (Object)value))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)(result != null ? new VersionedResult((Versioned<String>)result) : null)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{name}/{key}")
    @Produces(value={"application/json"})
    public void remove(@PathParam(value="name") String name, @PathParam(value="key") String key, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(map -> map.remove((Object)key))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)(result != null ? new VersionedResult((Versioned<String>)result) : null)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{name}/keys")
    @Produces(value={"application/json"})
    public void keys(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        this.getPrimitive(name).whenComplete((map, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)Sets.newHashSet((Iterator)map.keySet().iterator().sync())).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{name}/size")
    @Produces(value={"application/json"})
    public void size(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(map -> map.size())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{name}/clear")
    public void clear(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(map -> map.clear())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.noContent().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    static class VersionedResult {
        private final Versioned<String> value;

        public VersionedResult(Versioned<String> value) {
            this.value = value;
        }

        public String getValue() {
            return (String)this.value.value();
        }

        public long getVersion() {
            return this.value.version();
        }
    }
}

