/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.PrimitivesService;
import io.atomix.core.counter.AtomicCounter;
import io.atomix.core.election.AsyncLeaderElection;
import io.atomix.core.election.LeaderElection;
import io.atomix.core.generator.AtomicIdGenerator;
import io.atomix.core.lock.DistributedLock;
import io.atomix.core.map.AsyncConsistentMap;
import io.atomix.core.map.ConsistentMap;
import io.atomix.core.queue.AsyncWorkQueue;
import io.atomix.core.queue.WorkQueue;
import io.atomix.core.set.AsyncDistributedSet;
import io.atomix.core.set.DistributedSet;
import io.atomix.core.tree.AsyncDocumentTree;
import io.atomix.core.tree.DocumentTree;
import io.atomix.core.value.AsyncAtomicValue;
import io.atomix.core.value.AtomicValue;
import io.atomix.rest.resources.AbstractRestResource;
import io.atomix.rest.resources.AtomicCounterResource;
import io.atomix.rest.resources.AtomicIdGeneratorResource;
import io.atomix.rest.resources.AtomicValueResource;
import io.atomix.rest.resources.ConsistentMapResource;
import io.atomix.rest.resources.DistributedLockResource;
import io.atomix.rest.resources.DistributedSetResource;
import io.atomix.rest.resources.DocumentTreeResource;
import io.atomix.rest.resources.LeaderElectorResource;
import io.atomix.rest.resources.WorkQueueResource;
import io.atomix.rest.utils.PrimitiveCache;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/v1/primitives")
public class PrimitivesResource
extends AbstractRestResource {
    @Path(value="/counters/{name}")
    public AtomicCounterResource getCounter(@PathParam(value="name") String counterName, @Context PrimitiveCache primitiveCache) {
        return new AtomicCounterResource(primitiveCache.getPrimitive(counterName, primitives -> ((AtomicCounter)primitives.atomicCounterBuilder(counterName).build()).async()));
    }

    @GET
    @Path(value="/counters")
    @Produces(value={"application/json"})
    public Response getCounterNames(@Context PrimitivesService primitives) {
        return Response.ok((Object)primitives.getAtomicCounterNames()).build();
    }

    @Path(value="/elections/{name}")
    public LeaderElectorResource getElection(@PathParam(value="name") String electionName, @Context PrimitiveCache primitiveCache) {
        return new LeaderElectorResource((AsyncLeaderElection<String>)primitiveCache.getPrimitive(electionName, primitives -> ((LeaderElection)primitives.leaderElectionBuilder(electionName).build()).async()));
    }

    @GET
    @Path(value="/elections")
    @Produces(value={"application/json"})
    public Response getElectionsNames(@Context PrimitivesService primitives) {
        return Response.ok((Object)primitives.getLeaderElectorNames()).build();
    }

    @Path(value="/ids/{name}")
    public AtomicIdGeneratorResource getIdGenerator(@PathParam(value="name") String generatorName, @Context PrimitiveCache primitiveCache) {
        return new AtomicIdGeneratorResource(primitiveCache.getPrimitive(generatorName, primitives -> ((AtomicIdGenerator)primitives.atomicIdGeneratorBuilder(generatorName).build()).async()));
    }

    @GET
    @Path(value="/ids")
    @Produces(value={"application/json"})
    public Response getIdGeneratorNames(@Context PrimitivesService primitives) {
        return Response.ok((Object)primitives.getAtomicIdGeneratorNames()).build();
    }

    @Path(value="/locks/{name}")
    public DistributedLockResource getLock(@PathParam(value="name") String lockName, @Context PrimitiveCache primitiveCache) {
        return new DistributedLockResource(primitiveCache.getPrimitive(lockName, primitives -> ((DistributedLock)primitives.lockBuilder(lockName).build()).async()));
    }

    @GET
    @Path(value="/locks")
    @Produces(value={"application/json"})
    public Response getLockNames(@Context PrimitivesService primitives) {
        return Response.ok((Object)primitives.getDistributedLockNames()).build();
    }

    @Path(value="/maps/{name}")
    public ConsistentMapResource getMap(@PathParam(value="name") String mapName, @Context PrimitiveCache primitiveCache) {
        return new ConsistentMapResource((AsyncConsistentMap<String, String>)primitiveCache.getPrimitive(mapName, primitives -> ((ConsistentMap)primitives.consistentMapBuilder(mapName).build()).async()));
    }

    @GET
    @Path(value="/maps")
    @Produces(value={"application/json"})
    public Response getMapNames(@Context PrimitivesService primitives) {
        return Response.ok((Object)primitives.getConsistentMapNames()).build();
    }

    @Path(value="/queues/{name}")
    public WorkQueueResource getQueue(@PathParam(value="name") String queueName, @Context PrimitiveCache primitiveCache) {
        return new WorkQueueResource((AsyncWorkQueue<String>)primitiveCache.getPrimitive(queueName, primitives -> ((WorkQueue)primitives.workQueueBuilder(queueName).build()).async()));
    }

    @GET
    @Path(value="/queues")
    @Produces(value={"application/json"})
    public Response getQueueNames(@Context PrimitivesService primitives) {
        return Response.ok((Object)primitives.getWorkQueueNames()).build();
    }

    @Path(value="/sets/{name}")
    public DistributedSetResource getSet(@PathParam(value="name") String setName, @Context PrimitiveCache primitiveCache) {
        return new DistributedSetResource((AsyncDistributedSet<String>)primitiveCache.getPrimitive(setName, primitives -> ((DistributedSet)primitives.setBuilder(setName).build()).async()));
    }

    @GET
    @Path(value="/sets")
    @Produces(value={"application/json"})
    public Response getSetNames(@Context PrimitivesService primitives) {
        return Response.ok((Object)primitives.getSetNames()).build();
    }

    @Path(value="/trees/{name}")
    public DocumentTreeResource getTree(@PathParam(value="name") String treeName, @Context PrimitiveCache primitiveCache) {
        return new DocumentTreeResource((AsyncDocumentTree<String>)primitiveCache.getPrimitive(treeName, primitives -> ((DocumentTree)primitives.documentTreeBuilder(treeName).build()).async()));
    }

    @GET
    @Path(value="/trees")
    @Produces(value={"application/json"})
    public Response getTreeNames(@Context PrimitivesService primitives) {
        return Response.ok((Object)primitives.getDocumentTreeNames()).build();
    }

    @Path(value="/values/{name}")
    public AtomicValueResource getValue(@PathParam(value="name") String valueName, @Context PrimitiveCache primitiveCache) {
        return new AtomicValueResource((AsyncAtomicValue<String>)primitiveCache.getPrimitive(valueName, primitives -> ((AtomicValue)primitives.atomicValueBuilder(valueName).build()).async()));
    }

    @GET
    @Path(value="/values")
    @Produces(value={"application/json"})
    public Response getValueNames(@Context PrimitivesService primitives) {
        return Response.ok((Object)primitives.getAtomicValueNames()).build();
    }
}

