/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.set.AsyncDistributedSet;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedSetResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedSetResource.class);
    private final AsyncDistributedSet<String> set;

    public DistributedSetResource(AsyncDistributedSet<String> set) {
        this.set = set;
    }

    @GET
    @Produces(value={"application/json"})
    public void get(@Suspended AsyncResponse response) {
        this.set.getAsImmutableSet().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @PUT
    @Path(value="/{element}")
    @Produces(value={"application/json"})
    public void add(@PathParam(value="element") String element, @Suspended AsyncResponse response) {
        this.set.add((Object)element).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{element}")
    @Produces(value={"application/json"})
    public void contains(@PathParam(value="element") String element, @Suspended AsyncResponse response) {
        this.set.contains((Object)element).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{element}")
    @Produces(value={"application/json"})
    public void remove(@PathParam(value="element") String element, @Suspended AsyncResponse response) {
        this.set.remove((Object)element).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/size")
    @Produces(value={"application/json"})
    public void size(@Suspended AsyncResponse response) {
        this.set.size().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    public void clear(@Suspended AsyncResponse response) {
        this.set.clear().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

