/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.map.AsyncConsistentMap;
import io.atomix.rest.resources.AbstractRestResource;
import io.atomix.utils.time.Versioned;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentMapResource
extends AbstractRestResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsistentMapResource.class);
    private final AsyncConsistentMap<String, String> map;

    public ConsistentMapResource(AsyncConsistentMap<String, String> map) {
        this.map = map;
    }

    @GET
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public void get(@PathParam(value="key") String key, @Suspended AsyncResponse response) {
        this.map.get((Object)key).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)(result != null ? new VersionedResult((Versioned<String>)result) : null)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @PUT
    @Path(value="/{key}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public void put(@PathParam(value="key") String key, String value, @Suspended AsyncResponse response) {
        this.map.put((Object)key, (Object)value).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)(result != null ? new VersionedResult((Versioned<String>)result) : null)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{key}")
    @Produces(value={"application/json"})
    public void remove(@PathParam(value="key") String key, @Suspended AsyncResponse response) {
        this.map.remove((Object)key).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)(result != null ? new VersionedResult((Versioned<String>)result) : null)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/keys")
    @Produces(value={"application/json"})
    public void keys(@Suspended AsyncResponse response) {
        this.map.keySet().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/size")
    @Produces(value={"application/json"})
    public void size(@Suspended AsyncResponse response) {
        this.map.size().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/clear")
    public void clear(@Suspended AsyncResponse response) {
        this.map.clear().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.noContent().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/")
    @Produces(value={"application/json"})
    public void delete(@Suspended AsyncResponse response) {
        this.clear(response);
    }

    static class VersionedResult {
        private final Versioned<String> value;

        public VersionedResult(Versioned<String> value) {
            this.value = value;
        }

        public String getValue() {
            return (String)this.value.value();
        }

        public long getVersion() {
            return this.value.version();
        }
    }
}

