/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.protocol.SessionRequest;
import java.util.Objects;

public class ResetRequest
extends SessionRequest {
    private final long index;

    public static Builder builder() {
        return new Builder();
    }

    public ResetRequest(long session, long index) {
        super(session);
        this.index = index;
    }

    public long index() {
        return this.index;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.session, this.index);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ResetRequest) {
            ResetRequest request = (ResetRequest)object;
            return request.session == this.session && request.index == this.index;
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", this.session).add("index", this.index).toString();
    }

    public static class Builder
    extends SessionRequest.Builder<Builder, ResetRequest> {
        private long index;

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        public ResetRequest build() {
            this.validate();
            return new ResetRequest(this.session, this.index);
        }
    }
}

