/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.primitive.PrimitiveException;

public class RaftError {
    private final Type type;
    private final String message;

    public RaftError(Type type, String message) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
        this.message = message;
    }

    public Type type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public PrimitiveException createException() {
        return this.type.createException(this.message);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("message", (Object)this.message).toString();
    }

    public static enum Type {
        NO_LEADER{

            @Override
            PrimitiveException createException() {
                return this.createException("Failed to locate leader");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.Unavailable(message) : this.createException();
            }
        }
        ,
        QUERY_FAILURE{

            @Override
            PrimitiveException createException() {
                return this.createException("Failed to obtain read quorum");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.QueryFailure(message) : this.createException();
            }
        }
        ,
        COMMAND_FAILURE{

            @Override
            PrimitiveException createException() {
                return this.createException("Failed to obtain write quorum");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.CommandFailure(message) : this.createException();
            }
        }
        ,
        APPLICATION_ERROR{

            @Override
            PrimitiveException createException() {
                return this.createException("An application error occurred");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.ServiceException(message) : this.createException();
            }
        }
        ,
        ILLEGAL_MEMBER_STATE{

            @Override
            PrimitiveException createException() {
                return this.createException("Illegal member state");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.Unavailable(message) : this.createException();
            }
        }
        ,
        UNKNOWN_CLIENT{

            @Override
            PrimitiveException createException() {
                return this.createException("Unknown client");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.UnknownClient(message) : this.createException();
            }
        }
        ,
        UNKNOWN_SESSION{

            @Override
            PrimitiveException createException() {
                return this.createException("Unknown member session");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.UnknownSession(message) : this.createException();
            }
        }
        ,
        UNKNOWN_SERVICE{

            @Override
            PrimitiveException createException() {
                return this.createException("Unknown primitive service");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.UnknownService(message) : this.createException();
            }
        }
        ,
        CLOSED_SESSION{

            @Override
            PrimitiveException createException() {
                return this.createException("Closed session");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.ClosedSession(message) : this.createException();
            }
        }
        ,
        PROTOCOL_ERROR{

            @Override
            PrimitiveException createException() {
                return this.createException("Failed to reach consensus");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.Unavailable(message) : this.createException();
            }
        }
        ,
        CONFIGURATION_ERROR{

            @Override
            PrimitiveException createException() {
                return this.createException("Configuration failed");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.Unavailable(message) : this.createException();
            }
        }
        ,
        UNAVAILABLE{

            @Override
            PrimitiveException createException() {
                return this.createException("Service is unavailable");
            }

            @Override
            PrimitiveException createException(String message) {
                return message != null ? new PrimitiveException.Unavailable(message) : this.createException();
            }
        };


        abstract PrimitiveException createException();

        abstract PrimitiveException createException(String var1);
    }
}

