/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.utils;

import com.google.common.base.MoreObjects;
import io.atomix.utils.SlidingWindowCounter;
import io.atomix.utils.concurrent.ThreadContext;

public class LoadMonitor {
    private final SlidingWindowCounter loadCounter;
    private final int windowSize;
    private final int highLoadThreshold;

    public LoadMonitor(int windowSize, int highLoadThreshold, ThreadContext threadContext) {
        this.windowSize = windowSize;
        this.highLoadThreshold = highLoadThreshold;
        this.loadCounter = new SlidingWindowCounter(windowSize, threadContext);
    }

    public void recordEvent() {
        this.loadCounter.incrementCount();
    }

    public boolean isUnderHighLoad() {
        return this.loadCounter.get(this.windowSize) > (long)this.highLoadThreshold;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("windowSize", this.windowSize).add("highLoadThreshold", this.highLoadThreshold).toString();
    }
}

