/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session;

import io.atomix.primitive.PrimitiveId;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.session.RaftSession;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class RaftSessionRegistry {
    private final Map<Long, RaftSession> sessions = new ConcurrentHashMap<Long, RaftSession>();

    public RaftSession addSession(RaftSession session) {
        RaftSession existingSession = this.sessions.putIfAbsent((Long)session.sessionId().id(), session);
        return existingSession != null ? existingSession : session;
    }

    public RaftSession removeSession(SessionId sessionId) {
        return this.sessions.remove(sessionId.id());
    }

    public RaftSession getSession(SessionId sessionId) {
        return this.getSession((Long)sessionId.id());
    }

    public RaftSession getSession(long sessionId) {
        return this.sessions.get(sessionId);
    }

    public Collection<RaftSession> getSessions() {
        return this.sessions.values();
    }

    public Collection<RaftSession> getSessions(PrimitiveId primitiveId) {
        return this.sessions.values().stream().filter(session -> session.getService().serviceId().equals((Object)primitiveId)).filter(session -> session.getState().active()).collect(Collectors.toSet());
    }

    public void removeSessions(PrimitiveId primitiveId) {
        this.sessions.entrySet().removeIf(e -> ((RaftSession)e.getValue()).getService().serviceId().equals((Object)primitiveId));
    }
}

