/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.primitive.proxy.impl.AbstractPrimitiveProxy;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.impl.MemberSelectorManager;
import io.atomix.protocols.raft.proxy.impl.RaftProxyConnection;
import io.atomix.protocols.raft.proxy.impl.RaftProxyInvoker;
import io.atomix.protocols.raft.proxy.impl.RaftProxyListener;
import io.atomix.protocols.raft.proxy.impl.RaftProxyManager;
import io.atomix.protocols.raft.proxy.impl.RaftProxySequencer;
import io.atomix.protocols.raft.proxy.impl.RaftProxyState;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class DefaultRaftProxy
extends AbstractPrimitiveProxy
implements RaftProxy {
    private final String serviceName;
    private final PrimitiveType primitiveType;
    private final Duration minTimeout;
    private final Duration maxTimeout;
    private final RaftClientProtocol protocol;
    private final MemberSelectorManager selectorManager;
    private final RaftProxyManager sessionManager;
    private final ReadConsistency readConsistency;
    private final CommunicationStrategy communicationStrategy;
    private final ThreadContext context;
    private volatile RaftProxyListener proxyListener;
    private volatile RaftProxyInvoker proxyInvoker;
    private volatile RaftProxyState state;

    public DefaultRaftProxy(String serviceName, PrimitiveType primitiveType, RaftClientProtocol protocol, MemberSelectorManager selectorManager, RaftProxyManager sessionManager, ReadConsistency readConsistency, CommunicationStrategy communicationStrategy, ThreadContext context, Duration minTimeout, Duration maxTimeout) {
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName cannot be null");
        this.primitiveType = (PrimitiveType)Preconditions.checkNotNull((Object)primitiveType, (Object)"serviceType cannot be null");
        this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.selectorManager = (MemberSelectorManager)Preconditions.checkNotNull((Object)selectorManager, (Object)"selectorManager cannot be null");
        this.readConsistency = (ReadConsistency)((Object)Preconditions.checkNotNull((Object)((Object)readConsistency), (Object)"readConsistency cannot be null"));
        this.communicationStrategy = (CommunicationStrategy)((Object)Preconditions.checkNotNull((Object)((Object)communicationStrategy), (Object)"communicationStrategy cannot be null"));
        this.context = (ThreadContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        this.minTimeout = (Duration)Preconditions.checkNotNull((Object)minTimeout, (Object)"minTimeout cannot be null");
        this.maxTimeout = (Duration)Preconditions.checkNotNull((Object)maxTimeout, (Object)"maxTimeout cannot be null");
        this.sessionManager = (RaftProxyManager)Preconditions.checkNotNull((Object)sessionManager, (Object)"sessionManager cannot be null");
    }

    public String name() {
        return this.serviceName;
    }

    public PrimitiveType serviceType() {
        return this.primitiveType;
    }

    public SessionId sessionId() {
        return this.state != null ? this.state.getSessionId() : null;
    }

    public PrimitiveProxy.State getState() {
        return this.state.getState();
    }

    public void addStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        if (this.state != null) {
            this.state.addStateChangeListener(listener);
        }
    }

    public void removeStateChangeListener(Consumer<PrimitiveProxy.State> listener) {
        if (this.state != null) {
            this.state.removeStateChangeListener(listener);
        }
    }

    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        RaftProxyInvoker invoker = this.proxyInvoker;
        if (invoker == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("Session not open"));
        }
        return invoker.invoke(operation);
    }

    public void addEventListener(Consumer<PrimitiveEvent> listener) {
        if (this.proxyListener != null) {
            this.proxyListener.addEventListener(listener);
        }
    }

    public void removeEventListener(Consumer<PrimitiveEvent> listener) {
        if (this.proxyListener != null) {
            this.proxyListener.removeEventListener(listener);
        }
    }

    public CompletableFuture<PrimitiveProxy> connect() {
        return this.sessionManager.openSession(this.serviceName, this.primitiveType, this.readConsistency, this.communicationStrategy, this.minTimeout, this.maxTimeout).thenApply(state -> {
            this.state = state;
            RaftProxyConnection leaderConnection = new RaftProxyConnection(this.protocol, this.selectorManager.createSelector(CommunicationStrategy.LEADER), this.context, LoggerContext.builder(PrimitiveProxy.class).addValue((Object)state.getSessionId()).add("type", (Object)state.getPrimitiveType()).add("name", (Object)state.getPrimitiveName()).build());
            RaftProxyConnection sessionConnection = new RaftProxyConnection(this.protocol, this.selectorManager.createSelector(this.communicationStrategy), this.context, LoggerContext.builder(PrimitiveProxy.class).addValue((Object)state.getSessionId()).add("type", (Object)state.getPrimitiveType()).add("name", (Object)state.getPrimitiveName()).build());
            RaftProxySequencer sequencer = new RaftProxySequencer((RaftProxyState)state);
            this.proxyListener = new RaftProxyListener(this.protocol, this.selectorManager.createSelector(CommunicationStrategy.ANY), (RaftProxyState)state, sequencer, (Executor)this.context);
            this.proxyInvoker = new RaftProxyInvoker(leaderConnection, sessionConnection, (RaftProxyState)state, sequencer, this.sessionManager, this.context);
            return this;
        });
    }

    public CompletableFuture<Void> close() {
        if (this.state != null) {
            return this.sessionManager.closeSession(this.state.getSessionId()).whenComplete((result, error) -> this.state.setState(PrimitiveProxy.State.CLOSED));
        }
        return CompletableFuture.completedFuture(null);
    }

    public int hashCode() {
        return Objects.hash(this.state);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultRaftProxy && ((DefaultRaftProxy)object).state.getSessionId() == this.state.getSessionId();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", this.state != null ? this.state.getSessionId() : null).toString();
    }
}

