/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import java.util.Objects;

public class PollRequest
extends AbstractRaftRequest {
    private final long term;
    private final String candidate;
    private final long lastLogIndex;
    private final long lastLogTerm;

    public static Builder builder() {
        return new Builder();
    }

    public PollRequest(long term, String candidate, long lastLogIndex, long lastLogTerm) {
        this.term = term;
        this.candidate = candidate;
        this.lastLogIndex = lastLogIndex;
        this.lastLogTerm = lastLogTerm;
    }

    public long term() {
        return this.term;
    }

    public NodeId candidate() {
        return NodeId.from((String)this.candidate);
    }

    public long lastLogIndex() {
        return this.lastLogIndex;
    }

    public long lastLogTerm() {
        return this.lastLogTerm;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.term, this.candidate, this.lastLogIndex, this.lastLogTerm);
    }

    public boolean equals(Object object) {
        if (object instanceof PollRequest) {
            PollRequest request = (PollRequest)object;
            return request.term == this.term && request.candidate == this.candidate && request.lastLogIndex == this.lastLogIndex && request.lastLogTerm == this.lastLogTerm;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("candidate", (Object)this.candidate).add("lastLogIndex", this.lastLogIndex).add("lastLogTerm", this.lastLogTerm).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, PollRequest> {
        private long term = -1L;
        private String candidate;
        private long lastLogIndex = -1L;
        private long lastLogTerm = -1L;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withCandidate(NodeId candidate) {
            this.candidate = (String)((Object)((NodeId)Preconditions.checkNotNull((Object)candidate, (Object)"candidate cannot be null")).id());
            return this;
        }

        public Builder withLastLogIndex(long logIndex) {
            Preconditions.checkArgument((logIndex >= 0L ? 1 : 0) != 0, (Object)"lastLogIndex must be positive");
            this.lastLogIndex = logIndex;
            return this;
        }

        public Builder withLastLogTerm(long logTerm) {
            Preconditions.checkArgument((logTerm >= 0L ? 1 : 0) != 0, (Object)"lastLogTerm must be positive");
            this.lastLogTerm = logTerm;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkNotNull((Object)this.candidate, (Object)"candidate cannot be null");
            Preconditions.checkArgument((this.lastLogIndex >= 0L ? 1 : 0) != 0, (Object)"lastLogIndex must be positive");
            Preconditions.checkArgument((this.lastLogTerm >= 0L ? 1 : 0) != 0, (Object)"lastLogTerm must be positive");
        }

        public PollRequest build() {
            this.validate();
            return new PollRequest(this.term, this.candidate, this.lastLogIndex, this.lastLogTerm);
        }
    }
}

