/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.cluster.ClusterEvent;
import io.atomix.cluster.ClusterEventListener;
import io.atomix.cluster.ClusterService;
import io.atomix.cluster.Node;
import io.atomix.primitive.PrimitiveProtocol;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.protocols.raft.RaftProtocol;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.atomix.storage.StorageLevel;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.event.EventListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftPartitionGroup
implements ManagedPartitionGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftPartitionGroup.class);
    private final String name;
    private final int partitionSize;
    private final Map<PartitionId, RaftPartition> partitions = Maps.newConcurrentMap();
    private final List<PartitionId> sortedPartitionIds = Lists.newCopyOnWriteArrayList();
    private final ClusterEventListener clusterEventListener = this::handleClusterEvent;
    private PartitionManagementService managementService;
    private Collection<PartitionMetadata> metadata;
    private CompletableFuture<Void> metadataChangeFuture = CompletableFuture.completedFuture(null);

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public RaftPartitionGroup(String name, Collection<RaftPartition> partitions, int partitionSize) {
        this.name = name;
        this.partitionSize = partitionSize;
        partitions.forEach(p -> {
            this.partitions.put(p.id(), (RaftPartition)p);
            this.sortedPartitionIds.add(p.id());
        });
        Collections.sort(this.sortedPartitionIds);
    }

    public String name() {
        return this.name;
    }

    public PrimitiveProtocol.Type type() {
        return RaftProtocol.TYPE;
    }

    public Partition getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    public Collection<Partition> getPartitions() {
        return this.partitions.values();
    }

    public List<PartitionId> getPartitionIds() {
        return this.sortedPartitionIds;
    }

    public CompletableFuture<ManagedPartitionGroup> open(PartitionManagementService managementService) {
        this.managementService = managementService;
        managementService.getClusterService().addListener((EventListener)this.clusterEventListener);
        this.metadata = this.buildPartitions(managementService.getClusterService());
        List<CompletableFuture> futures = this.metadata.stream().map(metadata -> {
            RaftPartition partition = this.partitions.get(metadata.id());
            return partition.open((PartitionMetadata)metadata, managementService);
        }).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            LOGGER.info("Started");
            return this;
        });
    }

    private synchronized void handleClusterEvent(ClusterEvent event) {
        if (event.type() == ClusterEvent.Type.NODE_ADDED && ((Node)event.subject()).type() == Node.Type.DATA) {
            this.metadataChangeFuture = this.metadataChangeFuture.thenCompose(v -> {
                Collection<PartitionMetadata> partitions = this.buildPartitions(this.managementService.getClusterService());
                if (!this.metadata.equals(partitions)) {
                    this.metadata = partitions;
                    return Futures.allOf(partitions.stream().map(partitionMetadata -> {
                        RaftPartition partition = this.partitions.get(partitionMetadata.id());
                        return partition.update((PartitionMetadata)partitionMetadata, this.managementService);
                    }).collect(Collectors.toList())).thenApply(l -> null);
                }
                return CompletableFuture.completedFuture(null);
            });
        }
    }

    private Collection<PartitionMetadata> buildPartitions(ClusterService clusterService) {
        int partitionSize = this.partitionSize;
        if (partitionSize == 0) {
            partitionSize = clusterService.getNodes().size();
        }
        ArrayList sorted = new ArrayList(clusterService.getNodes().stream().filter(node -> node.type() == Node.Type.DATA).map(Node::id).collect(Collectors.toSet()));
        Collections.sort(sorted);
        int length = sorted.size();
        int count = Math.min(partitionSize, length);
        HashSet metadata = Sets.newHashSet();
        for (int i = 0; i < this.partitions.size(); ++i) {
            PartitionId partitionId = this.sortedPartitionIds.get(i);
            HashSet set = new HashSet(count);
            for (int j = 0; j < count; ++j) {
                set.add(sorted.get((i + j) % length));
            }
            metadata.add(new PartitionMetadata(partitionId, set));
        }
        return metadata;
    }

    public CompletableFuture<Void> close() {
        List<CompletableFuture> futures = this.partitions.values().stream().map(RaftPartition::close).collect(Collectors.toList());
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenRun(() -> LOGGER.info("Stopped"));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("partitions", this.partitions).toString();
    }

    public static class Builder
    extends PartitionGroup.Builder {
        private int numPartitions;
        private int partitionSize;
        private StorageLevel storageLevel = StorageLevel.MAPPED;
        private File dataDirectory = new File(System.getProperty("user.dir"), "data");

        protected Builder(String name) {
            super(name);
        }

        public Builder withNumPartitions(int numPartitions) {
            Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"numPartitions must be positive");
            this.numPartitions = numPartitions;
            return this;
        }

        public Builder withPartitionSize(int partitionSize) {
            Preconditions.checkArgument((partitionSize > 0 ? 1 : 0) != 0, (Object)"partitionSize must be positive");
            this.partitionSize = partitionSize;
            return this;
        }

        public Builder withStorageLevel(StorageLevel storageLevel) {
            this.storageLevel = (StorageLevel)Preconditions.checkNotNull((Object)storageLevel, (Object)"storageLevel cannot be null");
            return this;
        }

        public Builder withDataDirectory(File dataDir) {
            this.dataDirectory = (File)Preconditions.checkNotNull((Object)dataDir, (Object)"dataDir cannot be null");
            return this;
        }

        public ManagedPartitionGroup build() {
            File partitionsDir = new File(this.dataDirectory, "partitions");
            ArrayList<RaftPartition> partitions = new ArrayList<RaftPartition>(this.numPartitions);
            for (int i = 0; i < this.numPartitions; ++i) {
                partitions.add(new RaftPartition(PartitionId.from((String)this.name, (int)(i + 1)), this.storageLevel, new File(partitionsDir, String.valueOf(i + 1))));
            }
            return new RaftPartitionGroup(this.name, partitions, this.partitionSize);
        }
    }
}

