/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.cluster;

import io.atomix.cluster.NodeId;
import io.atomix.protocols.raft.cluster.RaftClusterEventListener;
import io.atomix.protocols.raft.cluster.RaftMember;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface RaftCluster {
    public RaftMember getLeader();

    public long getTerm();

    public void addLeaderElectionListener(Consumer<RaftMember> var1);

    public void removeLeaderElectionListener(Consumer<RaftMember> var1);

    public RaftMember getMember();

    public RaftMember getMember(NodeId var1);

    public Collection<RaftMember> getMembers();

    default public CompletableFuture<Void> bootstrap(NodeId ... cluster) {
        return this.bootstrap(Arrays.asList(cluster));
    }

    public CompletableFuture<Void> bootstrap(Collection<NodeId> var1);

    default public CompletableFuture<Void> listen(NodeId ... cluster) {
        return this.join(Arrays.asList(cluster));
    }

    public CompletableFuture<Void> listen(Collection<NodeId> var1);

    default public CompletableFuture<Void> join(NodeId ... cluster) {
        return this.join(Arrays.asList(cluster));
    }

    public CompletableFuture<Void> join(Collection<NodeId> var1);

    public CompletableFuture<Void> leave();

    public void addListener(RaftClusterEventListener var1);

    public void removeListener(RaftClusterEventListener var1);
}

