/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.event.RaftEvent;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.RaftProxyClient;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.SessionId;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class DelegatingRaftProxyClient
implements RaftProxyClient {
    private final RaftProxyClient delegate;

    public DelegatingRaftProxyClient(RaftProxyClient delegate) {
        this.delegate = (RaftProxyClient)Preconditions.checkNotNull((Object)delegate, (Object)"delegate cannot be null");
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public ServiceType serviceType() {
        return this.delegate.serviceType();
    }

    @Override
    public SessionId sessionId() {
        return this.delegate.sessionId();
    }

    @Override
    public RaftProxy.State getState() {
        return this.delegate.getState();
    }

    @Override
    public void addStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.delegate.addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.delegate.removeStateChangeListener(listener);
    }

    @Override
    public CompletableFuture<byte[]> execute(RaftOperation operation) {
        return this.delegate.execute(operation);
    }

    @Override
    public void addEventListener(Consumer<RaftEvent> listener) {
        this.delegate.addEventListener(listener);
    }

    @Override
    public void removeEventListener(Consumer<RaftEvent> listener) {
        this.delegate.removeEventListener(listener);
    }

    public CompletableFuture<RaftProxyClient> open() {
        return this.delegate.open();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public CompletableFuture<Void> close() {
        return this.delegate.close();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate).toString();
    }
}

