/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;

public final class SnapshotFile {
    @VisibleForTesting
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "snapshot";
    private final File file;

    public static boolean isSnapshotFile(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"file cannot be null");
        String fileName = file.getName();
        if (fileName.lastIndexOf(46) == -1) {
            return false;
        }
        if (!fileName.endsWith(".snapshot")) {
            return false;
        }
        String[] parts = fileName.substring(0, fileName.lastIndexOf(46)).split(String.valueOf('-'));
        if (parts.length < 2) {
            return false;
        }
        return SnapshotFile.isNumeric(parts[parts.length - 1]);
    }

    private static boolean isNumeric(String value) {
        for (char c : value.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static File createSnapshotFile(File directory, String serverName, long index) {
        return new File(directory, SnapshotFile.createSnapshotFileName(serverName, index));
    }

    @VisibleForTesting
    static String createSnapshotFileName(String serverName, long index) {
        return String.format("%s-%d.%s", serverName, index, EXTENSION);
    }

    SnapshotFile(File file) {
        this.file = file;
    }

    public File file() {
        return this.file;
    }

    public String name() {
        return SnapshotFile.parseName(this.file.getName());
    }

    @VisibleForTesting
    static String parseName(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1));
    }
}

