/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.storage.log.RaftLog;
import io.atomix.protocols.raft.storage.snapshot.SnapshotFile;
import io.atomix.protocols.raft.storage.snapshot.SnapshotStore;
import io.atomix.protocols.raft.storage.system.MetaStore;
import io.atomix.serializer.Serializer;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.journal.JournalSegmentFile;
import io.atomix.storage.statistics.StorageStatistics;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.function.Predicate;

public class RaftStorage {
    private final String prefix;
    private final StorageLevel storageLevel;
    private final File directory;
    private final Serializer serializer;
    private final int maxSegmentSize;
    private final int maxEntriesPerSegment;
    private final boolean dynamicCompaction;
    private final double freeDiskBuffer;
    private final boolean flushOnCommit;
    private final boolean retainStaleSnapshots;
    private final StorageStatistics statistics;

    public static Builder newBuilder() {
        return new Builder();
    }

    private RaftStorage(String prefix, StorageLevel storageLevel, File directory, Serializer serializer, int maxSegmentSize, int maxEntriesPerSegment, boolean dynamicCompaction, double freeDiskBuffer, boolean flushOnCommit, boolean retainStaleSnapshots) {
        this.prefix = prefix;
        this.storageLevel = storageLevel;
        this.directory = directory;
        this.serializer = serializer;
        this.maxSegmentSize = maxSegmentSize;
        this.maxEntriesPerSegment = maxEntriesPerSegment;
        this.dynamicCompaction = dynamicCompaction;
        this.freeDiskBuffer = freeDiskBuffer;
        this.flushOnCommit = flushOnCommit;
        this.retainStaleSnapshots = retainStaleSnapshots;
        this.statistics = new StorageStatistics(directory);
        directory.mkdirs();
    }

    public String prefix() {
        return this.prefix;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public File directory() {
        return this.directory;
    }

    public StorageLevel storageLevel() {
        return this.storageLevel;
    }

    public int maxLogSegmentSize() {
        return this.maxSegmentSize;
    }

    public int maxLogEntriesPerSegment() {
        return this.maxEntriesPerSegment;
    }

    public boolean dynamicCompaction() {
        return this.dynamicCompaction;
    }

    public double freeDiskBuffer() {
        return this.freeDiskBuffer;
    }

    public boolean isFlushOnCommit() {
        return this.flushOnCommit;
    }

    public boolean isRetainStaleSnapshots() {
        return this.retainStaleSnapshots;
    }

    public StorageStatistics statistics() {
        return this.statistics;
    }

    public MetaStore openMetaStore() {
        return new MetaStore(this, this.serializer);
    }

    public void deleteMetaStore() {
        this.deleteFiles(f -> f.getName().equals(String.format("%s.meta", this.prefix)) || f.getName().equals(String.format("%s.conf", this.prefix)));
    }

    public SnapshotStore openSnapshotStore() {
        return new SnapshotStore(this);
    }

    public void deleteSnapshotStore() {
        this.deleteFiles(f -> SnapshotFile.isSnapshotFile(f));
    }

    public RaftLog openLog() {
        return RaftLog.newBuilder().withName(this.prefix).withDirectory(this.directory).withStorageLevel(this.storageLevel).withSerializer(this.serializer).withMaxSegmentSize(this.maxSegmentSize).withMaxEntriesPerSegment(this.maxEntriesPerSegment).withFlushOnCommit(this.flushOnCommit).build();
    }

    public void deleteLog() {
        this.deleteFiles(f -> JournalSegmentFile.isSegmentFile((String)this.prefix, (File)f));
    }

    private void deleteFiles(Predicate<File> predicate) {
        this.directory.mkdirs();
        for (File file : this.directory.listFiles(f -> f.isFile() && predicate.test(f))) {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("directory", (Object)this.directory()).toString();
    }

    public static class Builder
    implements io.atomix.utils.Builder<RaftStorage> {
        private static final String DEFAULT_PREFIX = "atomix";
        private static final String DEFAULT_DIRECTORY = System.getProperty("user.dir");
        private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
        private static final int DEFAULT_MAX_ENTRIES_PER_SEGMENT = 0x100000;
        private static final boolean DEFAULT_DYNAMIC_COMPACTION = true;
        private static final double DEFAULT_FREE_DISK_BUFFER = 0.2;
        private static final boolean DEFAULT_FLUSH_ON_COMMIT = true;
        private static final boolean DEFAULT_RETAIN_STALE_SNAPSHOTS = false;
        private String prefix = "atomix";
        private StorageLevel storageLevel = StorageLevel.DISK;
        private File directory = new File(DEFAULT_DIRECTORY);
        private Serializer serializer;
        private int maxSegmentSize = 0x2000000;
        private int maxEntriesPerSegment = 0x100000;
        private boolean dynamicCompaction = true;
        private double freeDiskBuffer = 0.2;
        private boolean flushOnCommit = true;
        private boolean retainStaleSnapshots = false;

        private Builder() {
        }

        public Builder withPrefix(String prefix) {
            this.prefix = (String)Preconditions.checkNotNull((Object)prefix, (Object)"prefix cannot be null");
            return this;
        }

        public Builder withStorageLevel(StorageLevel storageLevel) {
            this.storageLevel = (StorageLevel)Preconditions.checkNotNull((Object)storageLevel, (Object)"storageLevel");
            return this;
        }

        public Builder withDirectory(String directory) {
            return this.withDirectory(new File((String)Preconditions.checkNotNull((Object)directory, (Object)"directory")));
        }

        public Builder withDirectory(File directory) {
            this.directory = (File)Preconditions.checkNotNull((Object)directory, (Object)"directory");
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            Preconditions.checkArgument((maxSegmentSize > 64 ? 1 : 0) != 0, (Object)"maxSegmentSize must be greater than 64");
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        public Builder withMaxEntriesPerSegment(int maxEntriesPerSegment) {
            Preconditions.checkArgument((maxEntriesPerSegment > 0 ? 1 : 0) != 0, (Object)"max entries per segment must be positive");
            Preconditions.checkArgument((maxEntriesPerSegment <= 0x100000 ? 1 : 0) != 0, (Object)"max entries per segment cannot be greater than 1048576");
            this.maxEntriesPerSegment = maxEntriesPerSegment;
            return this;
        }

        public Builder withDynamicCompaction() {
            return this.withDynamicCompaction(true);
        }

        public Builder withDynamicCompaction(boolean dynamicCompaction) {
            this.dynamicCompaction = dynamicCompaction;
            return this;
        }

        public Builder withFreeDiskBuffer(double freeDiskBuffer) {
            Preconditions.checkArgument((freeDiskBuffer > 0.0 ? 1 : 0) != 0, (Object)"freeDiskBuffer must be positive");
            Preconditions.checkArgument((freeDiskBuffer < 1.0 ? 1 : 0) != 0, (Object)"freeDiskBuffer must be less than 1");
            this.freeDiskBuffer = freeDiskBuffer;
            return this;
        }

        public Builder withFlushOnCommit() {
            return this.withFlushOnCommit(true);
        }

        public Builder withFlushOnCommit(boolean flushOnCommit) {
            this.flushOnCommit = flushOnCommit;
            return this;
        }

        public Builder withRetainStaleSnapshots() {
            return this.withRetainStaleSnapshots(true);
        }

        public Builder withRetainStaleSnapshots(boolean retainStaleSnapshots) {
            this.retainStaleSnapshots = retainStaleSnapshots;
            return this;
        }

        public RaftStorage build() {
            return new RaftStorage(this.prefix, this.storageLevel, this.directory, this.serializer, this.maxSegmentSize, this.maxEntriesPerSegment, this.dynamicCompaction, this.freeDiskBuffer, this.flushOnCommit, this.retainStaleSnapshots);
        }
    }
}

