/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.atomix.event.Event;
import io.atomix.protocols.phi.PhiAccrualFailureDetector;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.event.RaftEvent;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.PendingCommand;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.operation.OperationType;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.service.ServiceRevision;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.service.impl.DefaultServiceContext;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.session.RaftSessionEvent;
import io.atomix.protocols.raft.session.RaftSessionEventListener;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.utils.TimestampPrinter;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class RaftSessionContext
implements RaftSession {
    private static final int EVENT_BATCH_SIZE = 32768;
    private final Logger log;
    private final SessionId sessionId;
    private final MemberId member;
    private final String name;
    private final ServiceType serviceType;
    private final ReadConsistency readConsistency;
    private final long minTimeout;
    private final long maxTimeout;
    private final RaftServerProtocol protocol;
    private final DefaultServiceContext context;
    private final RaftContext server;
    private final ThreadContext eventExecutor;
    private volatile RaftSession.State state = RaftSession.State.CLOSED;
    private volatile long lastUpdated;
    private long lastHeartbeat;
    private PhiAccrualFailureDetector failureDetector;
    private long requestSequence;
    private volatile long commandSequence;
    private volatile long lastApplied;
    private volatile long commandLowWaterMark;
    private volatile long eventIndex;
    private volatile long completeIndex;
    private final Map<Long, List<Runnable>> sequenceQueries = new HashMap<Long, List<Runnable>>();
    private final Map<Long, List<Runnable>> indexQueries = new HashMap<Long, List<Runnable>>();
    private final Map<Long, PendingCommand> pendingCommands = new HashMap<Long, PendingCommand>();
    private final Map<Long, OperationResult> results = new HashMap<Long, OperationResult>();
    private final Queue<EventHolder> events = new LinkedList<EventHolder>();
    private volatile EventHolder currentEventList;
    private final Set<RaftSessionEventListener> eventListeners = new CopyOnWriteArraySet<RaftSessionEventListener>();

    public RaftSessionContext(SessionId sessionId, MemberId member, String name, ServiceType serviceType, ReadConsistency readConsistency, long minTimeout, long maxTimeout, long lastUpdated, DefaultServiceContext context, RaftContext server, ThreadContextFactory threadContextFactory) {
        this.sessionId = sessionId;
        this.member = member;
        this.name = name;
        this.serviceType = serviceType;
        this.readConsistency = readConsistency;
        this.minTimeout = minTimeout;
        this.maxTimeout = maxTimeout;
        this.lastUpdated = lastUpdated;
        this.eventIndex = (Long)sessionId.id();
        this.completeIndex = (Long)sessionId.id();
        this.lastApplied = (Long)sessionId.id();
        this.protocol = server.getProtocol();
        this.context = context;
        this.server = server;
        this.eventExecutor = threadContextFactory.createContext();
        this.failureDetector = new PhiAccrualFailureDetector(25, minTimeout / 2L);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftSession.class).addValue((Object)sessionId).add("type", (Object)context.serviceType()).add("name", (Object)context.serviceName()).build());
    }

    @Override
    public SessionId sessionId() {
        return this.sessionId;
    }

    @Override
    public String serviceName() {
        return this.name;
    }

    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    @Override
    public ServiceRevision serviceRevision() {
        return this.context.revision();
    }

    @Override
    public MemberId memberId() {
        return this.member;
    }

    @Override
    public ReadConsistency readConsistency() {
        return this.readConsistency;
    }

    @Override
    public long minTimeout() {
        return this.minTimeout;
    }

    @Override
    public long maxTimeout() {
        return this.maxTimeout;
    }

    public DefaultServiceContext getService() {
        return this.context;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(long lastUpdated) {
        this.lastUpdated = Math.max(this.lastUpdated, lastUpdated);
    }

    public boolean isTimedOut(long timestamp) {
        long lastUpdated = this.lastUpdated;
        return lastUpdated > 0L && timestamp - lastUpdated > this.maxTimeout;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(long lastHeartbeat) {
        this.lastHeartbeat = Math.max(this.lastHeartbeat, lastHeartbeat);
        this.failureDetector.report(lastHeartbeat);
    }

    public void resetHeartbeats() {
        this.lastHeartbeat = 0L;
        this.failureDetector = new PhiAccrualFailureDetector(25, this.minTimeout() / 2L);
    }

    public boolean isFailed(int threshold) {
        return this.failureDetector.phi() >= (double)threshold;
    }

    @Override
    public RaftSession.State getState() {
        return this.state;
    }

    private void setState(RaftSession.State state) {
        if (this.state != state) {
            this.state = state;
            this.log.debug("State changed: {}", (Object)state);
            switch (state) {
                case OPEN: {
                    this.eventListeners.forEach(l -> l.onEvent((Event)new RaftSessionEvent(RaftSessionEvent.Type.OPEN, this, this.getLastUpdated())));
                    break;
                }
                case EXPIRED: {
                    this.eventListeners.forEach(l -> l.onEvent((Event)new RaftSessionEvent(RaftSessionEvent.Type.EXPIRE, this, this.getLastUpdated())));
                    break;
                }
                case CLOSED: {
                    this.eventListeners.forEach(l -> l.onEvent((Event)new RaftSessionEvent(RaftSessionEvent.Type.CLOSE, this, this.getLastUpdated())));
                }
            }
        }
    }

    @Override
    public void addListener(RaftSessionEventListener listener) {
        this.eventListeners.add(listener);
    }

    @Override
    public void removeListener(RaftSessionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public long getRequestSequence() {
        return this.requestSequence;
    }

    public long nextRequestSequence() {
        return this.requestSequence + 1L;
    }

    public void setRequestSequence(long requestSequence) {
        this.requestSequence = Math.max(this.requestSequence, requestSequence);
    }

    public void resetRequestSequence(long requestSequence) {
        if (requestSequence > this.requestSequence) {
            this.requestSequence = requestSequence;
        }
    }

    public long getCommandSequence() {
        return this.commandSequence;
    }

    public long nextCommandSequence() {
        return this.commandSequence + 1L;
    }

    public void setCommandSequence(long sequence) {
        for (long i = this.commandSequence + 1L; i <= sequence; ++i) {
            this.commandSequence = i;
            List<Runnable> queries = this.sequenceQueries.remove(this.commandSequence);
            if (queries == null) continue;
            for (Runnable query : queries) {
                query.run();
            }
        }
    }

    public long getLastApplied() {
        return this.lastApplied;
    }

    public void setLastApplied(long index) {
        for (long i = this.lastApplied + 1L; i <= index; ++i) {
            this.lastApplied = i;
            List<Runnable> queries = this.indexQueries.remove(this.lastApplied);
            if (queries == null) continue;
            for (Runnable query : queries) {
                query.run();
            }
        }
    }

    public void registerSequenceQuery(long sequence, Runnable query) {
        List queries = this.sequenceQueries.computeIfAbsent(sequence, v -> new LinkedList());
        queries.add(query);
    }

    public void registerIndexQuery(long index, Runnable query) {
        List queries = this.indexQueries.computeIfAbsent(index, v -> new LinkedList());
        queries.add(query);
    }

    public void registerCommand(long sequence, PendingCommand pendingCommand) {
        this.pendingCommands.put(sequence, pendingCommand);
    }

    public PendingCommand getCommand(long sequence) {
        return this.pendingCommands.get(sequence);
    }

    public Collection<PendingCommand> getCommands() {
        return this.pendingCommands.values();
    }

    public PendingCommand removeCommand(long sequence) {
        return this.pendingCommands.remove(sequence);
    }

    public Collection<PendingCommand> clearCommands() {
        ArrayList commands = Lists.newArrayList(this.pendingCommands.values());
        this.pendingCommands.clear();
        return commands;
    }

    public void registerResult(long sequence, OperationResult result) {
        this.setRequestSequence(sequence);
        this.results.put(sequence, result);
    }

    public void clearResults(long sequence) {
        if (sequence > this.commandLowWaterMark) {
            long i = this.commandLowWaterMark + 1L;
            while (i <= sequence) {
                this.results.remove(i);
                this.commandLowWaterMark = i++;
            }
        }
    }

    public OperationResult getResult(long sequence) {
        return this.results.get(sequence);
    }

    public long getEventIndex() {
        return this.eventIndex;
    }

    public void setEventIndex(long eventIndex) {
        this.eventIndex = eventIndex;
    }

    @Override
    public void publish(RaftEvent event) {
        if (this.context.locked()) {
            return;
        }
        RaftSession.State state = this.state;
        Preconditions.checkState((state != RaftSession.State.EXPIRED ? 1 : 0) != 0, (Object)"session is expired");
        Preconditions.checkState((state != RaftSession.State.CLOSED ? 1 : 0) != 0, (Object)"session is closed");
        Preconditions.checkState((this.context.currentOperation() == OperationType.COMMAND ? 1 : 0) != 0, (Object)"session events can only be published during command execution");
        if (this.completeIndex > this.context.currentIndex()) {
            return;
        }
        if (this.currentEventList == null || this.currentEventList.eventIndex != this.context.currentIndex()) {
            long previousIndex = this.eventIndex;
            this.eventIndex = this.context.currentIndex();
            this.currentEventList = new EventHolder(this.eventIndex, previousIndex);
        }
        this.currentEventList.events.add(event);
    }

    public void commit(long index) {
        if (this.currentEventList != null && this.currentEventList.eventIndex == index) {
            this.events.add(this.currentEventList);
            this.sendEvents(this.currentEventList);
            this.currentEventList = null;
        }
        this.setLastApplied(index);
    }

    public long getLastCompleted() {
        EventHolder event = this.events.peek();
        if (event != null && event.eventIndex > this.completeIndex) {
            return event.eventIndex - 1L;
        }
        return this.lastApplied;
    }

    public void setLastCompleted(long lastCompleted) {
        this.completeIndex = lastCompleted;
    }

    private void clearEvents(long index) {
        if (index > this.completeIndex) {
            EventHolder event = this.events.peek();
            while (event != null && event.eventIndex <= index) {
                this.events.remove();
                this.completeIndex = event.eventIndex;
                event = this.events.peek();
            }
            this.completeIndex = index;
        }
    }

    public void resendEvents(long index) {
        this.clearEvents(index);
        for (EventHolder event : this.events) {
            this.sendEvents(event);
        }
    }

    private void sendEvents(EventHolder event) {
        if (this.server.isLeader()) {
            this.eventExecutor.execute(() -> {
                if (event.events.size() == 1) {
                    PublishRequest request = ((PublishRequest.Builder)PublishRequest.newBuilder().withSession((Long)this.sessionId().id())).withEventIndex(event.eventIndex).withBatchIndex(0).withBatchCount(1).withPreviousIndex(event.previousIndex).withEvents(event.events).build();
                    this.log.trace("Sending {}", (Object)request);
                    this.protocol.publish(this.member, request);
                } else {
                    List<List<RaftEvent>> batches = this.createBatches(event.events);
                    int i = 0;
                    for (List<RaftEvent> batch : batches) {
                        PublishRequest request = ((PublishRequest.Builder)PublishRequest.newBuilder().withSession((Long)this.sessionId().id())).withEventIndex(event.eventIndex).withBatchIndex(i++).withBatchCount(batches.size()).withPreviousIndex(event.previousIndex).withEvents(batch).build();
                        this.log.trace("Sending {}", (Object)request);
                        this.protocol.publish(this.member, request);
                    }
                }
            });
        }
    }

    private List<List<RaftEvent>> createBatches(List<RaftEvent> events) {
        ArrayList<List<RaftEvent>> batches = new ArrayList<List<RaftEvent>>(1);
        ArrayList<RaftEvent> currentBatch = new ArrayList<RaftEvent>(8);
        int currentBatchSize = 0;
        for (RaftEvent raftEvent : events) {
            if (currentBatchSize + raftEvent.value().length > 32768 && !currentBatch.isEmpty()) {
                batches.add(currentBatch);
                currentBatch = new ArrayList(8);
                currentBatchSize = 0;
            }
            currentBatch.add(raftEvent);
            currentBatchSize += raftEvent.value().length;
        }
        if (!currentBatch.isEmpty()) {
            batches.add(currentBatch);
        }
        return batches;
    }

    public void open() {
        this.setState(RaftSession.State.OPEN);
        this.protocol.registerResetListener(this.sessionId, request -> this.resendEvents(request.index()), (Executor)this.server.getServiceManager().executor());
    }

    public void expire() {
        this.setState(RaftSession.State.EXPIRED);
        this.protocol.unregisterResetListener(this.sessionId);
    }

    public void close() {
        this.setState(RaftSession.State.CLOSED);
        this.protocol.unregisterResetListener(this.sessionId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.sessionId});
    }

    public boolean equals(Object object) {
        return object instanceof RaftSession && ((RaftSession)object).sessionId() == this.sessionId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.context).add("session", (Object)this.sessionId).add("timestamp", (Object)TimestampPrinter.of((long)this.lastUpdated)).toString();
    }

    private static class EventHolder {
        private final long eventIndex;
        private final long previousIndex;
        private final List<RaftEvent> events = new LinkedList<RaftEvent>();

        private EventHolder(long eventIndex, long previousIndex) {
            this.eventIndex = eventIndex;
            this.previousIndex = previousIndex;
        }
    }
}

