/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.protocols.raft.event.RaftEvent;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.impl.MemberSelector;
import io.atomix.protocols.raft.proxy.impl.RaftProxySequencer;
import io.atomix.protocols.raft.proxy.impl.RaftProxyState;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.Logger;

final class RaftProxyListener {
    private final Logger log;
    private final RaftClientProtocol protocol;
    private final MemberSelector memberSelector;
    private final RaftProxyState state;
    private final Set<Consumer<RaftEvent>> listeners = Sets.newLinkedHashSet();
    private final RaftProxySequencer sequencer;
    private final Executor executor;

    public RaftProxyListener(RaftClientProtocol protocol, MemberSelector memberSelector, RaftProxyState state, RaftProxySequencer sequencer, Executor executor) {
        this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.memberSelector = (MemberSelector)Preconditions.checkNotNull((Object)memberSelector, (Object)"nodeSelector cannot be null");
        this.state = (RaftProxyState)Preconditions.checkNotNull((Object)state, (Object)"state cannot be null");
        this.sequencer = (RaftProxySequencer)Preconditions.checkNotNull((Object)sequencer, (Object)"sequencer cannot be null");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftProxy.class).addValue((Object)state.getSessionId()).add("type", (Object)state.getServiceType()).add("name", (Object)state.getServiceName()).build());
        protocol.registerPublishListener(state.getSessionId(), this::handlePublish, executor);
    }

    public void addEventListener(Consumer<RaftEvent> listener) {
        this.executor.execute(() -> this.listeners.add(listener));
    }

    public void removeEventListener(Consumer<RaftEvent> listener) {
        this.executor.execute(() -> this.listeners.remove(listener));
    }

    private void handlePublish(PublishRequest request) {
        this.log.trace("Received {}", (Object)request);
        if (request.session() != ((Long)this.state.getSessionId().id()).longValue()) {
            this.log.trace("Inconsistent session ID: {}", (Object)request.session());
            return;
        }
        long eventIndex = this.state.getEventIndex();
        if (request.eventIndex() <= eventIndex) {
            this.log.trace("Duplicate event index {}", (Object)request.eventIndex());
            return;
        }
        if (request.previousIndex() != eventIndex) {
            this.log.trace("Inconsistent event index: {}", (Object)request.previousIndex());
            ResetRequest resetRequest = ((ResetRequest.Builder)ResetRequest.newBuilder().withSession((Long)this.state.getSessionId().id())).withIndex(eventIndex).build();
            this.log.trace("Sending {}", (Object)resetRequest);
            this.protocol.reset(this.memberSelector.members(), resetRequest);
            return;
        }
        if (request.batchIndex() != this.state.getNextBatchIndex()) {
            this.log.trace("Inconsistent batch index: {}", (Object)request.batchIndex());
            ResetRequest resetRequest = ((ResetRequest.Builder)ResetRequest.newBuilder().withSession((Long)this.state.getSessionId().id())).withIndex(eventIndex).build();
            this.log.trace("Sending {}", (Object)resetRequest);
            this.protocol.reset(this.memberSelector.members(), resetRequest);
            return;
        }
        if (request.batchIndex() == request.batchCount() - 1) {
            this.state.setEventIndex(request.eventIndex());
            this.state.setNextBatchIndex(0);
        } else {
            this.state.setNextBatchIndex(this.state.getNextBatchIndex() + 1);
        }
        this.sequencer.sequenceEvent(request, () -> {
            for (RaftEvent event : request.events()) {
                for (Consumer<RaftEvent> listener : this.listeners) {
                    listener.accept(event);
                }
            }
        });
    }

    public CompletableFuture<Void> close() {
        this.protocol.unregisterPublishListener(this.state.getSessionId());
        return CompletableFuture.completedFuture(null);
    }
}

