/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotFile;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.protocols.raft.storage.snapshot.SnapshotStore;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.protocols.raft.storage.snapshot.StoredSnapshot;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSnapshot
extends StoredSnapshot {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSnapshot.class);
    private final SnapshotFile file;

    FileSnapshot(SnapshotFile file, SnapshotDescriptor descriptor, SnapshotStore store) {
        super(descriptor, store);
        this.file = (SnapshotFile)Preconditions.checkNotNull((Object)file, (Object)"file cannot be null");
    }

    @Override
    public synchronized SnapshotWriter openWriter() {
        this.checkWriter();
        FileBuffer buffer = FileBuffer.allocate((File)this.file.file(), (int)64);
        this.descriptor.copyTo((Buffer)buffer);
        int length = buffer.position(64).readInt();
        return this.openWriter(new SnapshotWriter(buffer.skip(length).mark(), this), this.descriptor);
    }

    @Override
    protected void closeWriter(SnapshotWriter writer) {
        int length = writer.buffer.position() - 68;
        writer.buffer.writeInt(64, length).flush();
        super.closeWriter(writer);
    }

    @Override
    public synchronized SnapshotReader openReader() {
        Preconditions.checkState((boolean)this.file.file().exists(), (String)"missing snapshot file: %s", (Object)this.file.file());
        FileBuffer buffer = FileBuffer.allocate((File)this.file.file(), (int)64);
        SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)buffer);
        int length = buffer.position(64).readInt();
        return this.openReader(new SnapshotReader(buffer.mark().limit(68 + length), this), descriptor);
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    public Snapshot complete() {
        FileBuffer buffer = FileBuffer.allocate((File)this.file.file(), (int)64);
        try (SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)buffer);){
            descriptor.lock();
        }
        return super.complete();
    }

    @Override
    public void delete() {
        LOGGER.debug("Deleting {}", (Object)this);
        Path path = this.file.file().toPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(this.file.file().toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

