/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import io.atomix.protocols.raft.service.ServiceRevision;
import io.atomix.protocols.raft.service.impl.DefaultServiceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class RaftServiceRegistry
implements Iterable<DefaultServiceContext> {
    private final Map<String, SortedMap<Integer, DefaultServiceContext>> services = new ConcurrentHashMap<String, SortedMap<Integer, DefaultServiceContext>>();

    public void registerService(DefaultServiceContext service) {
        this.services.computeIfAbsent(service.serviceName(), name -> new ConcurrentSkipListMap()).put(service.revision().revision(), service);
    }

    public DefaultServiceContext getRevision(String name, ServiceRevision revision) {
        Map revisions = this.services.get(name);
        return revisions != null ? (DefaultServiceContext)revisions.get(revision.revision()) : null;
    }

    public DefaultServiceContext getCurrentRevision(String name) {
        SortedMap<Integer, DefaultServiceContext> revisions = this.services.get(name);
        if (revisions == null) {
            return null;
        }
        Integer lastKey = revisions.lastKey();
        if (lastKey == null) {
            return null;
        }
        return (DefaultServiceContext)revisions.get(lastKey);
    }

    public Collection<DefaultServiceContext> getRevisions(String name) {
        SortedMap<Integer, DefaultServiceContext> revisions = this.services.get(name);
        return revisions != null ? revisions.values() : Collections.emptyList();
    }

    @Override
    public Iterator<DefaultServiceContext> iterator() {
        return this.services.values().stream().flatMap(s -> s.values().stream()).iterator();
    }
}

